import torch
import matplotlib.pyplot as plt
import sys
import numpy as np
import math
sys.path.append("../src")
from functions_to_generate import simple_cosine

ps = [15, 25]
t = torch.arange(3*math.lcm(*ps))
print(t)
fs = [1/p for p in ps] #, 1/31]
ampls = [0.71, 1] #, 0.63]
phases = [0, np.pi/2]
y = torch.zeros(len(t))
for i in range(len(fs)):
    y += simple_cosine(t, fs[i], phase=phases[i], amplitude=ampls[i])
fig, axes = plt.subplots(nrows=1)
axes.plot(y, label='x')
plt.xlabel('Time')
plt.tight_layout()
plt.show()