using FileIO
using LinearAlgebra
using MLDatasets

function get_low_ringrank_data(R,J)
    @assert length(J) == length(R) "length of R and J is not same"
    D = length(J)
    G = Vector{Array{Float64,3}}(undef,D)
    for i = 1:D
        if i != D
            G[i] = rand(R[i],J[i],R[i+1])
        else
            G[D] = rand(R[D],J[D],R[1])
        end
    end
    T = reconst(G)
    return T
end

function load_realdata(dataset;label=false,num_data=500,target_number=2)
    dataset_dir = "../../../data/TTCH/"
    fn = "tensor_"*dataset
    fp = joinpath(dataset_dir,fn*".jld2")
    T = load(fp,fn)
    if label == false
        if dataset == "TT_Origami"
            T = T .- minimum(T)
        end
        return T
    else
        labels = load(fp,fn*"_label")
        return T, labels
    end
end
