using Glob
using FileIO
using JLD2
using Images

function main_obj(objn)
    names = glob("data$objn/*.png")
    L = length(names)

    H = 40
    W = 40
    Tc = zeros(H,W,3,L)
    labels = zeros(Int64,L)
    l = 1
    for name in names
        @show name
        img = load(name)
        img = imresize(img, (H, W))
        T = zeros(Float64,H,W,3)
        T[:,:,1] = red.(img)
        T[:,:,2] = green.(img)
        T[:,:,3] = blue.(img)
        Tc[:,:,:,l] = T
        l += 1
    end
    # load("tensor_COIL100.jld2","tensor_COIL100") reads tensor
    # load("tensor_COIL100.jld2","tensor_COIL100_label") reads labels
    save("tensor_COIL100_obj$objn.jld2","tensor_COIL100_obj$objn",Tc)
end

main_obj(4)
main_obj(5)
main_obj(7)
main_obj(10)
main_obj(17)
main_obj(23)
main_obj(28)
main_obj(38)
main_obj(42)
main_obj(78)