#!/bin/bash
TEMPS=('1.0' '1.1' '1.3') 


# Inference reasoning paths
export CUDA_VISIBLE_DEVICES=0
MODEL="path of internlm2-math-plus-7b"

python inference.py --model ${MODEL} --data MATH --template intern --passk 1
python inference.py --model ${MODEL} --data AIME_1983_2024 --template intern --passk 1
python inference.py --model ${MODEL} --data OlympiadBench --template intern --passk 1
python inference.py --model ${MODEL} --data Odyssey --template intern --passk 1


for TEMP in "${TEMPS[@]}"
do
python inference.py --model ${MODEL} --data MATH --template intern --temperature ${TEMP} --passk 100
done

for TEMP in "${TEMPS[@]}"
do
    python inference.py --model ${MODEL} --data AIME_1983_2024 --template intern --temperature ${TEMP} --passk 256
    python inference.py --model ${MODEL} --data OlympiadBench --template intern --temperature ${TEMP} --passk 256
    python inference.py --model ${MODEL} --data Odyssey --template intern --temperature ${TEMP} --passk 256
done

# Estimate confidence
DATASETS256=('AIME_1983_2024' 'Odyssey' 'OlympiadBench')
DATASETS100=('MATH')
MODELS=('internlm2-math-plus-7b') 
METHODS=('compute_perp.py' 'compute_sc.py' 'compute_pc.py' 'compute_dwpc.py')
for TEMP in "${TEMPS[@]}"
do
    for MODEL in "${MODELS[@]}"
    do
        for METHOD in "${METHODS[@]}"
        do
            for DATASET in "${DATASETS100[@]}"
            do
                python ${METHOD} --path ./results/${MODEL}/${DATASET}/${DATASET}-intern-${TEMP}-0.95-100-0.json
            done
            for DATASET in "${DATASETS256[@]}"
            do
                python ${METHOD} --path ./results/${MODEL}/${DATASET}/${DATASET}-intern-${TEMP}-0.95-256-0.json
            done
        done
    done
done