# README

This submission provides a full pipeline for training, feature extraction, and unlearning. It includes two proposed unlearning methods, POU and COU, applied to CIFAR-10 using both ResNet and DINOv2 features. In addition, it includes implementations of NegGrad and Retrain baselines.

SISA is implemented from [https://github.com/cleverhans-lab/machine-unlearning](https://github.com/cleverhans-lab/machine-unlearning)

Unrolling SGD is implemented from [https://github.com/cleverhans-lab/unrolling-sgd](https://github.com/cleverhans-lab/unrolling-sgd)

Label-Agnostic Forgetting is implemented from [https://github.com/ShaofeiShen768/LAF](https://github.com/ShaofeiShen768/LAF)

---

## Pretraining

### `pretrain_resnet18_mlp.py`

Trains a ResNet-18 backbone with a 3-layer residual MLP head on CIFAR-10 using cross-entropy loss.

**Usage**

```bash
python pretrain_resnet18_mlp.py \
  --output-path /path/to/save/checkpoint.pth
```

**Arguments**

* `--output-path`: (required) Path to save the trained `.pth` model checkpoint.

> Note: All other training parameters (e.g., batch size, learning rate, epochs) are fixed in the script.

---

## Pull-to-Outlier Unlearning (POU)

### `extract_features_resnet_POU.py`

Extracts 512-D train and test features using the ResNet+MLP model.

**Usage**

```bash
python extract_features_resnet_POU.py \
  --weights-path /path/to/resnet_mlp_checkpoint.pth \
  --output-prefix cifar10_resnet
```

**Arguments**

* `--weights-path`: (required) Path to the trained ResNet+MLP checkpoint.
* `--output-prefix`: (required) Prefix for the output `.npy` files:

  * `<prefix>_train_features_cross_ent.npy`
  * `<prefix>_train_labels_cross_ent.npy`
  * `<prefix>_test_features_cross_ent.npy`
  * `<prefix>_test_labels_cross_ent.npy`

### `POU.py`

Performs instance-level unlearning by pushing selected features to synthetic outlier targets.

**Usage**

```bash
python POU.py \
  --weights-path /path/to/resnet_mlp_checkpoint.pth \
  --output-prefix cifar10_resnet
```

**Arguments**

* `--weights-path`: (required) Path to the ResNet+MLP checkpoint.
* `--output-prefix`: (required) Prefix matching the feature files produced above.
---

## Contrastive Objective-level Unlearning (COU)

### `extract_features_COU.py`

Extracts 1024-D DINOv2 features from a CIFAR-10 training subset (1000 images per class).

**Usage**

```bash
python extract_features_COU.py \
  --output-prefix DINO_COU_cifar10
```

**Arguments**

* `--output-prefix`: (required) Prefix for the saved feature and label files:

  * `<prefix>_train_features.npy`
  * `<prefix>_train_labels.npy`

### `COU.py`

Performs instance-level unlearning via contrastive training followed by unlearning by restoring original embeddings.

**Usage**

```bash
python COU.py \
  --weights-path /path/to/projection_checkpoint.pth \
  --data-prefix DINO_COU_cifar10
```

**Arguments**

* `--weights-path`: (required) Path to linear projection checkpoint. If not used, training starts from scratch.
* `--data-prefix`: (required) Prefix for the `.npy` feature/label files from `extract_features_COU.py`.

> All hyperparameters such as learning rate, batch size, number of epochs, and temperature are fixed in the script.

