using nonconvex_power_alm

using Statistics, DelimitedFiles

import LinearAlgebra as LA
import ProximalOperators
import ProximalAlgorithms
import Random
import AdaProx

Random.seed!(1)
LOG_TO_FILE = true

#################################################
### PARAMETERS
#################################################

DATASET = gevp_polynomial
TOL_OBJ = 1e-3                  # Objective tolerance
TOL_CON = 1e-3                  # Constraint tolerance
VERBOSE = true                 # Verbosity of inner solver

#################################################
### Generate problem data
#################################################

n = 500
gevp, opt_val, res = generate_gevp_data(n, DATASET)

# Random initialization
x0 = Random.rand(n)
# x0 ./= LA.norm(x0)

λ = 1e0
normC = LA.opnorm(gevp.C)
γ_rule = (β, y) -> begin
    temp = .5 / (2 * normC + 1000 + 100 * β)
    return temp
end
ρ_rule = (β, y) -> begin
    # return -0.001 * LA.eigmin(gevp.C)
    return -0.2 * LA.eigmin(gevp.C) + β
end
TRIPLE_LOOP = false
INNER_MAXIT = TRIPLE_LOOP ? 1000 : 100000
IPPM_MAX_IT = 10

#################################################
### Run power ALM
#################################################

normC = LA.opnorm(gevp.C)
γ_rule = (β, y) -> begin
    temp = .5 / (10 * normC + 5000 + 500 * β)
    return temp
end

#################################################
### Run power ALM with q = 0.1
#################################################

println("Solving gevp problem with power ALM and q = 0.1...")
include("run_power_alm_0.1.jl")

#################################################
### Run power ALM with q = 0.2
#################################################

println("Solving gevp problem with power ALM and q = 0.2...")
include("run_power_alm_0.2.jl")

#################################################
### Run power ALM with q = 0.3
#################################################

println("Solving gevp problem with power ALM and q = 0.3...")
include("run_power_alm_0.3.jl")

# normC = LA.opnorm(gevp.C)
# γ_rule = (β, y) -> begin
#     temp = .5 / (2 * normC + 1000 + 100 * β)# * 10
#     return temp
# end

#################################################
### Run power ALM with q = 0.4
#################################################

println("Solving gevp problem with power ALM and q = 0.4...")
include("run_power_alm_0.4.jl")

#################################################
### Run power ALM with q = 0.5
#################################################

println("Solving gevp problem with power ALM and q = 0.5...")
include("run_power_alm_0.5.jl")

#################################################
### Run power ALM with q = 0.6
#################################################

println("Solving gevp problem with power ALM and q = 0.6...")
include("run_power_alm_0.6.jl")

# normC = LA.opnorm(gevp.C)
# γ_rule = (β, y) -> begin
#     temp = .5 / (2 * normC + 1000 + 100 * β) # * 100
#     return temp
# end

#################################################
### Run power ALM with q = 0.7
#################################################

println("Solving gevp problem with power ALM and q = 0.7...")
include("run_power_alm_0.7.jl")

# #################################################
# ### Run power ALM with q = 0.75
# #################################################

println("Solving gevp problem with power ALM and q = 0.75...")
include("run_power_alm_0.75.jl")

# #################################################
# ### Run power ALM with q = 0.8
# #################################################

println("Solving gevp problem with power ALM and q = 0.8...")
include("run_power_alm_0.8.jl")

#################################################
### Run power ALM with q = 0.85
#################################################

println("Solving gevp problem with power ALM and q = 0.85...")
include("run_power_alm_0.85.jl")

#################################################
### Run power ALM with q = 0.9
#################################################

println("Solving gevp problem with power ALM and q = 0.9...")
include("run_power_alm_0.9.jl")

# #################################################
# ### Run power ALM with q = 0.95
# #################################################

println("Solving gevp problem with power ALM and q = 0.95...")
include("run_power_alm_0.95.jl")

#################################################
### Run power ALM with q = 1.00
#################################################

println("Solving gevp problem with power ALM and q = 1.00...")
include("run_power_alm_1.0.jl")

# #################################################
# ### Run classical ALM
# #################################################

# println("Solving gevp problem with classical ALM...")
# include("run_classical_alm.jl")

# #################################################
# ### Results
# #################################################

println("Total number of iterations: ")
println("q = 0.10:\t\t\t$(res_power_01.nit)")
println("q = 0.20:\t\t\t$(res_power_02.nit)")
println("q = 0.30:\t\t\t$(res_power_03.nit)")
println("q = 0.40:\t\t\t$(res_power_04.nit)")
println("q = 0.50:\t\t\t$(res_power_05.nit)")
println("q = 0.60:\t\t\t$(res_power_06.nit)")
println("q = 0.70:\t\t\t$(res_power_07.nit)")
println("q = 0.75:\t\t\t$(res_power_075.nit)")
println("q = 0.80:\t\t\t$(res_power_08.nit)")
println("q = 0.85:\t\t\t$(res_power_085.nit)")
println("q = 0.90:\t\t\t$(res_power_09.nit)")
println("q = 0.95:\t\t\t$(res_power_095.nit)")
println("q = 1.00:\t\t\t$(res_power_100.nit)")
# println("Sahin ref:\t\t\t$(res_classical.nit)")

if LOG_TO_FILE
data = LA.zeros(1, 3 * 5)

data[2] = abs(res_power_02.hist.objective[res_power_02.k+1] - opt_val)
data[1] = res_power_02.hist.feasibility[res_power_02.k+1]
data[3] = res_power_02.hist.nit[res_power_02.k+1]

data[5] = abs(res_power_04.hist.objective[res_power_04.k+1] - opt_val)
data[4] = res_power_04.hist.feasibility[res_power_04.k+1]
data[6] = res_power_04.hist.nit[res_power_04.k+1]

data[8] = abs(res_power_06.hist.objective[res_power_06.k+1] - opt_val)
data[7] = res_power_06.hist.feasibility[res_power_06.k+1]
data[9] = res_power_06.hist.nit[res_power_06.k+1]

data[11] = abs(res_power_08.hist.objective[res_power_08.k+1] - opt_val)
data[10] = res_power_08.hist.feasibility[res_power_08.k+1]
data[12] = res_power_08.hist.nit[res_power_08.k+1]

data[14] = abs(res_power_100.hist.objective[res_power_100.k+1] - opt_val)
data[13] = res_power_100.hist.feasibility[res_power_100.k+1]
data[15] = res_power_100.hist.nit[res_power_100.k+1]

io = open("experiments/gevp/results/$(DATASET).csv", "a")
writedlm(io, data)
close(io)

# io = open("experiments/gevp/results/$(DATASET).csv", "r")
# datas = readdlm(io)
# close(io)
# avgs = sum(datas, dims = 1) ./ size(datas)[1]
# io = open("experiments/gevp/results/$(DATASET).csv", "a")
# writedlm(io, avgs)
# close(io)

end