using Plots
using LaTeXStrings

pgfplotsx()

############################################
### Suboptimality vs iterations
############################################

fig_suboptimality = plot(
    xlabel = "# Gradients",
    ylabel = L"\vert f(x) - f^* \vert",
    fmt = :pdf,
    legend = true
)

# ##### Sahin ref.
# plot!(
#     res_classical.hist.nit[1:res_classical.k+1],
#     abs.(res_classical.hist.objective[1:res_classical.k+1] .- opt_val),
#     yaxis=:log,
#     label=["Classical ALM (ref.)"]
# )

##### q = 1.
plot!(
    res_power_100.hist.nit[1:res_power_100.k+1],
    abs.(res_power_100.hist.objective[1:res_power_100.k+1] .- opt_val),
    yaxis=:log,
    label=[L"\nu = 1"],
    marker=(:circle,5)
)

# ##### q = 0.95
# plot!(
#     res_power_095.hist.nit[1:res_power_095.k+1],
#     abs.(res_power_095.hist.objective[1:res_power_095.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.95"],
#     marker=(:circle,5)
# )

# ##### q = 0.9
# plot!(
#     res_power_09.hist.nit[1:res_power_09.k+1],
#     abs.(res_power_09.hist.objective[1:res_power_09.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.9"],
#     marker=(:circle,5)
# )

# ##### q = 0.85
# plot!(
#     res_power_085.hist.nit[1:res_power_085.k+1],
#     abs.(res_power_085.hist.objective[1:res_power_085.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.85"],
#     marker=(:circle,5)
# )

##### q = 0.8
plot!(
    res_power_08.hist.nit[1:res_power_08.k+1],
    abs.(res_power_08.hist.objective[1:res_power_08.k+1] .- opt_val),
    yaxis=:log,
    label=[L"\nu = 0.8"],
    marker=(:circle,5)
)

# ##### q = 0.75
# plot!(
#     res_power_075.hist.nit[1:res_power_075.k+1],
#     abs.(res_power_075.hist.objective[1:res_power_075.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.75"],
#     marker=(:circle,5)
# )

# ##### q = 0.7
# plot!(
#     res_power_07.hist.nit[1:res_power_07.k+1],
#     abs.(res_power_07.hist.objective[1:res_power_07.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.7"],
#     marker=(:circle,5)
# )

##### q = 0.6
plot!(
    res_power_06.hist.nit[1:res_power_06.k+1],
    abs.(res_power_06.hist.objective[1:res_power_06.k+1] .- opt_val),
    yaxis=:log,
    label=[L"\nu = 0.6"],
    marker=(:circle,5)
)

# ##### q = 0.5
# plot!(
#     res_power_05.hist.nit[1:res_power_05.k+1],
#     abs.(res_power_05.hist.objective[1:res_power_05.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.5"],
#     marker=(:circle,5)
# )

##### q = 0.4
plot!(
    res_power_04.hist.nit[1:res_power_04.k+1],
    abs.(res_power_04.hist.objective[1:res_power_04.k+1] .- opt_val),
    yaxis=:log,
    label=[L"\nu = 0.4"],
    marker=(:circle,5)
)

# ##### q = 0.3
# plot!(
#     res_power_03.hist.nit[1:res_power_03.k+1],
#     abs.(res_power_03.hist.objective[1:res_power_03.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.3"],
#     marker=(:circle,5)
# )

# ##### q = 0.2
# plot!(
#     res_power_02.hist.nit[1:res_power_02.k+1],
#     abs.(res_power_02.hist.objective[1:res_power_02.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.2"],
#     marker=(:circle,5)
# )

# ##### q = 0.1
# plot!(
#     res_power_01.hist.nit[1:res_power_01.k+1],
#     abs.(res_power_01.hist.objective[1:res_power_01.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"\nu = 0.1"],
#     marker=(:circle,5)
# )

savefig("experiments/gevp/results/$(DATASET)_objective.pdf")
savefig("experiments/gevp/results/$(DATASET)_objective.tikz")

############################################
### Feasibility vs iterations
############################################

fig_feasibility = plot(
    xlabel = "# Gradients",
    ylabel = L"\Vert A(x) \Vert",
    fmt = :pdf,
    legend = true
)

# ##### Sahin ref.
# plot!(
#     res_classical.hist.nit[1:res_classical.k+1],
#     res_classical.hist.feasibility[1:res_classical.k+1],
#     yaxis=:log,
#     label=["Classical ALM (ref.)"]
# )

##### q = 1.
plot!(
    res_power_100.hist.nit[1:res_power_100.k+1],
    res_power_100.hist.feasibility[1:res_power_100.k+1],
    yaxis=:log,
    label=[L"\nu = 1"],
    marker=(:circle,5)
)

# ##### q = 0.95
# plot!(
#     res_power_095.hist.nit[1:res_power_095.k+1],
#     res_power_095.hist.feasibility[1:res_power_095.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.95"],
#     marker=(:circle,5)
# )

# ##### q = 0.9
# plot!(
#     res_power_09.hist.nit[1:res_power_09.k+1],
#     res_power_09.hist.feasibility[1:res_power_09.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.9"],
#     marker=(:circle,5)
# )

# ##### q = 0.85
# plot!(
#     res_power_085.hist.nit[1:res_power_085.k+1],
#     res_power_085.hist.feasibility[1:res_power_085.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.85"],
#     marker=(:circle,5)
# )

##### q = 0.8
plot!(
    res_power_08.hist.nit[1:res_power_08.k+1],
    res_power_08.hist.feasibility[1:res_power_08.k+1],
    yaxis=:log,
    label=[L"\nu = 0.8"],
    marker=(:circle,5)
)

# ##### q = 0.75
# plot!(
#     res_power_075.hist.nit[1:res_power_075.k+1],
#     res_power_075.hist.feasibility[1:res_power_075.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.75"],
#     marker=(:circle,5)
# )

# ##### q = 0.7
# plot!(
#     res_power_07.hist.nit[1:res_power_07.k+1],
#     res_power_07.hist.feasibility[1:res_power_07.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.7"],
#     marker=(:circle,5)
# )

##### q = 0.6
plot!(
    res_power_06.hist.nit[1:res_power_06.k+1],
    res_power_06.hist.feasibility[1:res_power_06.k+1],
    yaxis=:log,
    label=[L"\nu = 0.6"],
    marker=(:circle,5)
)

# ##### q = 0.5
# plot!(
#     res_power_05.hist.nit[1:res_power_05.k+1],
#     res_power_05.hist.feasibility[1:res_power_05.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.5"],
#     marker=(:circle,5)
# )

##### q = 0.4
plot!(
    res_power_04.hist.nit[1:res_power_04.k+1],
    res_power_04.hist.feasibility[1:res_power_04.k+1],
    yaxis=:log,
    label=[L"\nu = 0.4"],
    marker=(:circle,5)
)

# ##### q = 0.3
# plot!(
#     res_power_03.hist.nit[1:res_power_03.k+1],
#     res_power_03.hist.feasibility[1:res_power_03.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.3"],
#     marker=(:circle,5)
# )

# ##### q = 0.2
# plot!(
#     res_power_02.hist.nit[1:res_power_02.k+1],
#     res_power_02.hist.feasibility[1:res_power_02.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.2"],
#     marker=(:circle,5)
# )

# ##### q = 0.1
# plot!(
#     res_power_01.hist.nit[1:res_power_01.k+1],
#     res_power_01.hist.feasibility[1:res_power_01.k+1],
#     yaxis=:log,
#     label=[L"\nu = 0.1"],
#     marker=(:circle,5)
# )

savefig("experiments/gevp/results/$(DATASET)_feasibility.pdf")
savefig("experiments/gevp/results/$(DATASET)_feasibility.tikz")


############################################
### iterations vs powers
############################################

fig_feasibility = plot(
    xlabel = L"\nu",
    ylabel = "# Gradients",
    fmt = :pdf,
    legend = false,
    # xticks = :native,
    # yticks = :native,
    formatter = :plain,
)

plot!(
    [
        0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.
    ],
    [
        res_power_01.hist.nit[res_power_01.k+1],
        res_power_02.hist.nit[res_power_02.k+1],
        res_power_03.hist.nit[res_power_03.k+1],
        res_power_04.hist.nit[res_power_04.k+1],
        res_power_05.hist.nit[res_power_05.k+1],
        res_power_06.hist.nit[res_power_06.k+1],
        res_power_07.hist.nit[res_power_07.k+1],
        # res_power_075.hist.nit[res_power_075.k+1],
        res_power_08.hist.nit[res_power_08.k+1],
        # res_power_085.hist.nit[res_power_085.k+1],
        res_power_09.hist.nit[res_power_09.k+1],
        # res_power_095.hist.nit[res_power_095.k+1],
        res_power_100.hist.nit[res_power_100.k+1],
    ],
    marker=(:circle,5)
)

savefig("experiments/gevp/results/$(DATASET)_powers.pdf")
savefig("experiments/gevp/results/$(DATASET)_powers.tikz")