### This file assumes that the GEVP data is contained in a variable `gevp`.

#################################################
### Create solver instance
#################################################

normC = LA.opnorm(gevp.C)
γ_rule = (β, y) -> begin
    temp = .5 / (2 * n * β + normC + β * sqrt(2 * n) * LA.norm(y ./ β .- 1.))
    return temp
end

gevp_solver = GEVPSolver(
    problem = gevp,
    x0 = x0,
    y0 = zeros(1),
    σ0 = 10.,
    initial_inner_tol = 1e-1,
    λ = 1e-1,
    β = (k) -> 1.01^((k-1)/4),
)

################################################
### Run solver
################################################

res_classical = run_alm(
    gevp_solver,
    (solver, state) -> begin 
        return abs(solver.f(state.x) - opt_val) < TOL_OBJ && LA.norm(state.Ax) < TOL_CON
    end,
    maxit = 650,
    q = 1.,
    inner_max_it = 10.,
    inner_solver = ProximalAlgorithms.FastForwardBackward,
    update_inner_max_it = (solver, state, k) -> (state.inner_max_it = min(1.01 * state.inner_max_it, 5000.)),
    minimum_gamma = 1e-12,
    γ_rule = γ_rule,
    adaptive_gamma = false,
    verbose = VERBOSE,
    logging = true
);

@assert begin
    temp = gevp.C * res_classical.x ./ (gevp.B * res_classical.x)
    all(x -> x <= 1e-3, (temp .- mean(temp)) / LA.cond(gevp.C))
end

temp = gevp.C * res_classical.x ./ (gevp.B * res_classical.x)
println(maximum(abs.((temp .- mean(temp)) / LA.cond(gevp.C))))