using nonconvex_power_alm
using Statistics, DelimitedFiles
using Plots, LaTeXStrings

pgfplotsx()


DATASET = quadratics_gaussian
TRIPLE_LOOP = false
m = 80
n = 400
m = 20
n = 100

########################################################

io = open("experiments/quadratics/results/$(DATASET)_$(m)_$(n)_$(TRIPLE_LOOP ? "triple" : "double")_fs_large.csv", "r")
datas = readdlm(io)
close(io)

datas = datas[1:end-1, 1:end]
datas_mean = mean(datas, dims = 1)
datas_std = std(datas, dims = 1)

fig_feasibility = plot(
    xlabel = L"\nu",
    ylabel = L"f^*",
    fmt = :pdf,
    legend = false,
    formatter = :plain,
)

# plot!( 
#     [
#         0.6, 0.7, 0.8, 0.9, 1.
#     ],
#     datas_mean[1:end],
#     ribbon=datas_std[1:end],
#     fillalpha = 0.1,
#     marker=(:circle,5)
# )
groupedviolin!(
    repeat([
        0.6, 0.7, 0.8, 0.9, 1.
    ], outer = 100),
    vec(datas[1:end,1:end]'),
    side=:right,
    fillalpha = 0.5,
)

savefig("experiments/quadratics/results/$(DATASET)_$(m)_$(n)_$(TRIPLE_LOOP ? "triple" : "double")_fs_confidence.pdf")
savefig("experiments/quadratics/results/$(DATASET)_$(m)_$(n)_$(TRIPLE_LOOP ? "triple" : "double")_fs_confidence.tikz")