### This file assumes that the QUADRATICS data is contained in a variable `quadratics`.

#################################################
### Create solver instance
#################################################

normQ = LA.opnorm(quadratics.Q)
γ_rule = (β, y) -> begin
    temp = .5 / (2 * n * β + normQ + β * sqrt(2 * n) * LA.norm(y ./ β .- 1.))
    return temp
end

quadratics_solver = QUADRATICSSolver(
    problem = quadratics,
    x0 = x0,
    y0 = zeros(m),
    σ0 = 10.,
    initial_inner_tol = 1e-1,
    λ = 1e-1,
    β = (k) -> 1.2^((k-1)/4),
)

################################################
### Run solver
################################################

res_classical = run_alm(
    quadratics_solver,
    (solver, state) -> begin 
        return abs(solver.f(state.x) - opt_val) < TOL_OBJ && LA.norm(state.Ax) < TOL_CON
    end,
    maxit = 650,
    q = 1.,
    inner_max_it = 10.,
    inner_solver = ProximalAlgorithms.FastForwardBackward,
    update_inner_max_it = (solver, state, k) -> (state.inner_max_it = min(1.01 * state.inner_max_it, 5000.)),
    minimum_gamma = 1e-12,
    γ_rule = γ_rule,
    adaptive_gamma = false,
    verbose = VERBOSE,
    logging = true
);