using Plots
using LaTeXStrings

pgfplotsx()

############################################
### Suboptimality vs iterations
############################################

fig_suboptimality = plot(
    xlabel = "# UPFAG iters",
    ylabel = L"\vert f(x) - f^* \vert",
    fmt = :pdf,
    legend = true,
    yaxis=:log,
    # xticks = :native,
    # yticks = :native,
    formatter = :plain,
)

# ##### Sahin ref.
# plot!(
#     res_classical.hist.nit[1:res_classical.k+1],
#     abs.(res_classical.hist.objective[1:res_classical.k+1] .- opt_val),
#     yaxis=:log,
#     label=["Classical ALM (ref.)"]
# )

##### q = 1.
plot!(
    res_power_100.hist.nit[1:10:res_power_100.k+1],
    abs.(res_power_100.hist.objective[1:10:res_power_100.k+1] .- opt_val),
    yaxis=:log,
    label=[L"q = 1"],
    marker=(:circle,5)
)

# ##### q = 0.95
# plot!(
#     res_power_095.hist.nit[1:res_power_095.k+1],
#     abs.(res_power_095.hist.objective[1:res_power_095.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"q = 0.95"],
#     marker=(:circle,5)
# )

##### q = 0.9
plot!(
    res_power_09.hist.nit[1:10:res_power_09.k+1],
    abs.(res_power_09.hist.objective[1:10:res_power_09.k+1] .- opt_val),
    yaxis=:log,
    label=[L"q = 0.9"],
    marker=(:circle,5)
)

# ##### q = 0.85
# plot!(
#     res_power_085.hist.nit[1:res_power_085.k+1],
#     abs.(res_power_085.hist.objective[1:res_power_085.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"q = 0.85"],
#     marker=(:circle,5)
# )

##### q = 0.8
plot!(
    res_power_08.hist.nit[1:10:res_power_08.k+1],
    abs.(res_power_08.hist.objective[1:10:res_power_08.k+1] .- opt_val),
    yaxis=:log,
    label=[L"q = 0.8"],
    marker=(:circle,5)
)

# ##### q = 0.75
# plot!(
#     res_power_075.hist.nit[1:res_power_075.k+1],
#     abs.(res_power_075.hist.objective[1:res_power_075.k+1] .- opt_val),
#     yaxis=:log,
#     label=[L"q = 0.75"],
#     marker=(:circle,5)
# )

##### q = 0.7
plot!(
    res_power_07.hist.nit[1:10:res_power_07.k+1],
    abs.(res_power_07.hist.objective[1:10:res_power_07.k+1] .- opt_val),
    yaxis=:log,
    label=[L"q = 0.7"],
    marker=(:circle,5)
)

savefig("experiments/clustering/results/$(DATASET)_objective.pdf")
savefig("experiments/clustering/results/$(DATASET)_objective.tikz")

############################################
### Feasibility vs iterations
############################################

fig_feasibility = plot(
    xlabel = "# UPFAG iters",
    ylabel = L"\Vert A(x) \Vert",
    fmt = :pdf,
    legend = true,
    yaxis=:log,
    # xticks = :native,
    # yticks = :native,
    formatter = :plain,
)

# ##### Sahin ref.
# plot!(
#     res_classical.hist.nit[1:res_classical.k+1],
#     res_classical.hist.feasibility[1:res_classical.k+1],
#     yaxis=:log,
#     label=["Classical ALM (ref.)"]
# )

##### q = 1.
plot!(
    res_power_100.hist.nit[1:10:res_power_100.k+1],
    res_power_100.hist.feasibility[1:10:res_power_100.k+1],
    yaxis=:log,
    label=[L"q = 1"],
    marker=(:circle,5)
)

# ##### q = 0.95
# plot!(
#     res_power_095.hist.nit[1:res_power_095.k+1],
#     res_power_095.hist.feasibility[1:res_power_095.k+1],
#     yaxis=:log,
#     label=[L"q = 0.95"],
#     marker=(:circle,5)
# )

##### q = 0.9
plot!(
    res_power_09.hist.nit[1:10:res_power_09.k+1],
    res_power_09.hist.feasibility[1:10:res_power_09.k+1],
    yaxis=:log,
    label=[L"q = 0.9"],
    marker=(:circle,5)
)

# ##### q = 0.85
# plot!(
#     res_power_085.hist.nit[1:res_power_085.k+1],
#     res_power_085.hist.feasibility[1:res_power_085.k+1],
#     yaxis=:log,
#     label=[L"q = 0.85"],
#     marker=(:circle,5)
# )

##### q = 0.8
plot!(
    res_power_08.hist.nit[1:10:res_power_08.k+1],
    res_power_08.hist.feasibility[1:10:res_power_08.k+1],
    yaxis=:log,
    label=[L"q = 0.8"],
    marker=(:circle,5)
)

# ##### q = 0.75
# plot!(
#     res_power_075.hist.nit[1:res_power_075.k+1],
#     res_power_075.hist.feasibility[1:res_power_075.k+1],
#     yaxis=:log,
#     label=[L"q = 0.75"],
#     marker=(:circle,5)
# )

##### q = 0.7
plot!(
    res_power_07.hist.nit[1:10:res_power_07.k+1],
    res_power_07.hist.feasibility[1:10:res_power_07.k+1],
    yaxis=:log,
    label=[L"q = 0.7"],
    marker=(:circle,5)
)

savefig("experiments/clustering/results/$(DATASET)_feasibility.pdf")
savefig("experiments/clustering/results/$(DATASET)_feasibility.tikz")

############################################
### iterations vs powers
############################################

fig_feasibility = plot(
    xlabel = L"\nu",
    ylabel = "# UPFAG iters",
    fmt = :pdf,
    legend = false,
    # xticks = :native,
    # yticks = :native,
    formatter = :plain,
)

if DATASET === clustering_mnist
    plot!(
        [
            0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.
        ],
        [
            res_power_065.hist.nit[res_power_065.k+1],
            res_power_07.hist.nit[res_power_07.k+1],
            res_power_075.hist.nit[res_power_075.k+1],
            res_power_08.hist.nit[res_power_08.k+1],
            res_power_085.hist.nit[res_power_085.k+1],
            res_power_09.hist.nit[res_power_09.k+1],
            res_power_095.hist.nit[res_power_095.k+1],
            res_power_100.hist.nit[res_power_100.k+1],
        ],
        marker=(:circle,5)
    )
else
    plot!(
        [
            0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.
        ],
        [
            res_power_07.hist.nit[res_power_07.k+1],
            res_power_075.hist.nit[res_power_075.k+1],
            res_power_08.hist.nit[res_power_08.k+1],
            res_power_085.hist.nit[res_power_085.k+1],
            res_power_09.hist.nit[res_power_09.k+1],
            res_power_095.hist.nit[res_power_095.k+1],
            res_power_100.hist.nit[res_power_100.k+1],
        ],
        marker=(:circle,5)
    )
end

savefig("experiments/clustering/results/$(DATASET)_powers.pdf")
savefig("experiments/clustering/results/$(DATASET)_powers.tikz")

