### This file assumes that the CLUSTERING data is contained in a variable `clustering`.

#################################################
### Create solver instance
#################################################

γ_rule = (β, y) -> begin
    temp = .5 / (2 * n * β + normD + β * sqrt(2 * n) * LA.norm(y ./ β .- 1.))
    return temp
end

clustering_solver = CLUSTERINGSolver(
    problem = clustering,
    x0 = x0,
    y0 = zeros(n),
    σ0 = 10.,
    initial_inner_tol = 1e-1,
    λ = λ,
    β = (k) -> 1.01^((k-1)/4),
)

################################################
### Run solver
################################################

res_classical = run_alm(
    clustering_solver,
    (solver, state) -> begin 
        return abs(solver.f(state.x) - opt_val) < TOL_OBJ && LA.norm(state.Ax) < TOL_CON
    end,
    maxit = 450,
    q = 1.,
    inner_max_it = 10.,
    inner_solver = ProximalAlgorithms.FastForwardBackward,
    update_inner_max_it = (solver, state, k) -> (state.inner_max_it = min(1.01 * state.inner_max_it, 10000.)),
    minimum_gamma = 1e-12,
    γ_rule = γ_rule,
    adaptive_gamma = false,
    verbose = VERBOSE,
    logging = true
);