### This file assumes that the CLUSTERING data is contained in a variable `clustering`.

#################################################
### Create solver instance
#################################################

clustering_solver = CLUSTERINGSolver(
    problem = clustering,
    x0 = x0,
    y0 = zeros(n),
    σ0 = 10.,
    initial_inner_tol = 1e-1,
    λ = λ,
    # β = (k) -> 5. * 5.0^(k - 1),
    β = (k) -> 5 * 1.1^(k-1)
)

################################################
### Run solver
################################################

res_power_08 = run_alm(
    clustering_solver,
    (solver, state) -> begin 
        return abs(solver.f(state.x) - opt_val) < TOL_OBJ && LA.norm(state.Ax) < TOL_CON
    end,
    maxit = 100,
    q = .8,
    inner_max_it = INNER_MAXIT,
    inner_solver = TRIPLE_LOOP ? AdaProx.adaptive_proxgrad : UPFAG,
    update_inner_max_it = (solver, state, k) -> (state.inner_max_it = min(2 * state.inner_max_it, INNER_MAXIT)),
    minimum_gamma = 1e-10,
    γ_rule = γ_rule,
    adaptive_gamma = false,
    verbose = VERBOSE,
    logging = true,
    ρ_rule = ρ_rule,
    triple_loop = TRIPLE_LOOP,
    ippm_max_it = IPPM_MAX_IT,
);