### This file assumes that the GEVP data is contained in a variable `gevp`.

TOL_OBJ_0_8 = TOL_OBJ                  # Objective tolerance
TOL_CON_0_8 = TOL_CON                  # Constraint tolerance

#################################################
### Create solver instance
#################################################

gevp_solver = GEVPSolver(
    problem = gevp,
    x0 = x0,
    y0 = zeros(1),
    σ0 = 10.,
    initial_inner_tol = 1e-1,
    λ = λ,
    # β = (k) -> 1 * 1.25^(k - 1),
    β = (k) -> 0.01 * 3^(k - 1),
)

# γ_rule = (β, y) -> begin
#     temp = .5 / (2 * normC + 1000 + 100 * β)
#     return temp
# end

################################################
### Run solver
################################################

res_power_08 = run_alm(
    gevp_solver,
    (solver, state) -> begin 
        return abs(solver.f(state.x) - opt_val) < TOL_OBJ_0_8 && LA.norm(state.Ax) < TOL_CON_0_8
    end,
    maxit = 500,
    q = .8,
    inner_max_it = INNER_MAXIT,
    inner_solver = TRIPLE_LOOP ? AdaProx.adaptive_proxgrad : ProximalAlgorithms.FastForwardBackward,
    update_inner_max_it = (solver, state, k) -> (state.inner_max_it = min(2 * state.inner_max_it, INNER_MAXIT)),
    minimum_gamma = 1e-10,
    γ_rule = γ_rule,
    adaptive_gamma = false,
    verbose = VERBOSE,
    logging = true,
    ρ_rule = ρ_rule,
    triple_loop = TRIPLE_LOOP,
    ippm_max_it = IPPM_MAX_IT,
);

temp = gevp.C * res_power_08.x ./ (gevp.B * res_power_08.x)
println(maximum(abs.((temp .- mean(temp)) / LA.cond(gevp.C))))