using nonconvex_power_alm
using Statistics, DelimitedFiles
using Plots, LaTeXStrings
using StatsPlots

pgfplotsx()


DATASET = quadratics_gaussian
TRIPLE_LOOP = false
m = 80
n = 400
m = 20
n = 100

########################################################

io = open("experiments/quadratics/results/$(DATASET)_$(m)_$(n)_$(TRIPLE_LOOP ? "triple" : "double")_large.csv", "r")
datas = readdlm(io)
close(io)

datas = datas[1:end-1, 1:end]
datas_mean = mean(datas, dims = 1)
datas_std = 2 .* std(datas, dims = 1)

fig_feasibility = plot(
    xlabel = L"\nu",
    ylabel = "# UPFAG iters",
    fmt = :pdf,
    legend = false,
    formatter = :plain,
)

# plot!( 
#     [
#         0.6, 0.7, 0.8, 0.9, 1.
#     ],
#     datas_mean[3:3:end],
#     ribbon=datas_std[3:3:end],
#     fillalpha = 0.1,
#     marker=(:circle,5)
# )
groupedviolin!(
    repeat([
        0.6, 0.7, 0.8, 0.9, 1.
    ], outer = 100),
    vec(datas[1:end,3:3:end]'),
    side=:right,
    fillalpha = 0.5,
)

savefig("experiments/quadratics/results/$(DATASET)_$(m)_$(n)_$(TRIPLE_LOOP ? "triple" : "double")_powers_confidence.pdf")
savefig("experiments/quadratics/results/$(DATASET)_$(m)_$(n)_$(TRIPLE_LOOP ? "triple" : "double")_powers_confidence.tikz")