### This file assumes that the QUADRATICS data is contained in a variable `quadratics`.

TOL_OBJ_0_6 = TOL_OBJ                  # Objective tolerance
TOL_CON_0_6 = TOL_CON                  # Constraint tolerance

#################################################
### Create solver instance
#################################################

quadratics_solver = QUADRATICSSolver(
    problem = quadratics,
    x0 = x0,
    y0 = zeros(m),
    σ0 = 10.,
    initial_inner_tol = 1e-1,
    λ = λ,
    β = β,
)

################################################
### Run solver
################################################

res_power_06 = run_alm(
    quadratics_solver,
    (solver, state) -> begin 
        return LA.norm(state.res, Inf) < TOL_OBJ_0_6 && LA.norm(state.Ax) < TOL_CON_0_6
        # return LA.norm(state.Ax) < TOL_CON_0_6
    end,
    maxit = 500,
    q = .6,
    inner_max_it = INNER_MAXIT,
    inner_solver = TRIPLE_LOOP ? AdaProx.adaptive_proxgrad : UPFAG,
    update_inner_max_it = (solver, state, k) -> (state.inner_max_it = min(2 * state.inner_max_it, INNER_MAXIT)),
    minimum_gamma = 1e-10,
    γ_rule = γ_rule,
    adaptive_gamma = false,
    verbose = VERBOSE,
    logging = true,
    ρ_rule = ρ_rule,
    triple_loop = TRIPLE_LOOP,
    ippm_max_it = IPPM_MAX_IT,
);