/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.Evaluator;
import edu.stanford.nlp.util.SystemUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;

public abstract class CmdEvaluator
implements Evaluator {
    private static final Pattern cmdSplitPattern = Pattern.compile("\\s+");
    protected boolean saveOutput = false;
    private String outString;
    private String errString;
    protected String description;

    public abstract void setValues(double[] var1);

    public abstract String[] getCmd();

    public abstract void outputToCmd(OutputStream var1);

    protected static String[] getCmd(String cmdStr) {
        if (cmdStr == null) {
            return null;
        }
        return cmdSplitPattern.split(cmdStr);
    }

    public String getOutput() {
        return this.outString;
    }

    public String getError() {
        return this.errString;
    }

    public String toString() {
        return this.description;
    }

    public void evaluateCmd(String[] cmd) {
        try {
            SystemUtils.ProcessOutputStream outputStream;
            StringWriter outSw = null;
            StringWriter errSw = null;
            if (this.saveOutput) {
                outSw = new StringWriter();
                errSw = new StringWriter();
                outputStream = new SystemUtils.ProcessOutputStream(cmd, (Writer)outSw, (Writer)errSw);
            } else {
                outputStream = new SystemUtils.ProcessOutputStream(cmd, new PrintWriter(System.err));
            }
            this.outputToCmd(outputStream);
            outputStream.close();
            if (this.saveOutput) {
                this.outString = outSw.toString();
                this.errString = errSw.toString();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public double evaluate(double[] x) {
        this.setValues(x);
        this.evaluateCmd(this.getCmd());
        return 0.0;
    }
}

