/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sentiment;

import java.io.Serializable;

public class RNNTrainOptions
implements Serializable {
    public int batchSize = 27;
    public int epochs = 400;
    public int debugOutputEpochs = 8;
    public int maxTrainTimeSeconds = 86400;
    public double learningRate = 0.01;
    public double scalingForInit = 1.0;
    private double[] classWeights = null;
    public double regTransformMatrix = 0.001;
    public double regClassification = 1.0E-4;
    public double regWordVector = 1.0E-4;
    public double initialAdagradWeight = 0.0;
    public int adagradResetFrequency = 1;
    public double regTransformTensor = 0.001;
    private static final long serialVersionUID = 1L;

    public double getClassWeight(int i) {
        if (this.classWeights == null) {
            return 1.0;
        }
        return this.classWeights[i];
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("TRAIN OPTIONS\n");
        result.append("batchSize=" + this.batchSize + "\n");
        result.append("epochs=" + this.epochs + "\n");
        result.append("debugOutputEpochs=" + this.debugOutputEpochs + "\n");
        result.append("maxTrainTimeSeconds=" + this.maxTrainTimeSeconds + "\n");
        result.append("learningRate=" + this.learningRate + "\n");
        result.append("scalingForInit=" + this.scalingForInit + "\n");
        if (this.classWeights == null) {
            result.append("classWeights=null\n");
        } else {
            result.append("classWeights=");
            result.append(this.classWeights[0]);
            for (int i = 1; i < this.classWeights.length; ++i) {
                result.append("," + this.classWeights[i]);
            }
            result.append("\n");
        }
        result.append("regTransformMatrix=" + this.regTransformMatrix + "\n");
        result.append("regTransformTensor=" + this.regTransformTensor + "\n");
        result.append("regClassification=" + this.regClassification + "\n");
        result.append("regWordVector=" + this.regWordVector + "\n");
        result.append("initialAdagradWeight=" + this.initialAdagradWeight + "\n");
        result.append("adagradResetFrequency=" + this.adagradResetFrequency + "\n");
        return result.toString();
    }

    public int setOption(String[] args, int argIndex) {
        if (args[argIndex].equalsIgnoreCase("-batchSize")) {
            this.batchSize = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-epochs")) {
            this.epochs = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-debugOutputEpochs")) {
            this.debugOutputEpochs = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-maxTrainTimeSeconds")) {
            this.maxTrainTimeSeconds = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-learningRate")) {
            this.learningRate = Double.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-scalingForInit")) {
            this.scalingForInit = Double.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-regTransformMatrix")) {
            this.regTransformMatrix = Double.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-regTransformTensor")) {
            this.regTransformTensor = Double.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-regClassification")) {
            this.regClassification = Double.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-regWordVector")) {
            this.regWordVector = Double.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-initialAdagradWeight")) {
            this.initialAdagradWeight = Double.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-adagradResetFrequency")) {
            this.adagradResetFrequency = Integer.valueOf(args[argIndex + 1]);
            return argIndex + 2;
        }
        if (args[argIndex].equalsIgnoreCase("-classWeights")) {
            String classWeightString = args[argIndex + 1];
            String[] pieces = classWeightString.split(",");
            this.classWeights = new double[pieces.length];
            for (int i = 0; i < pieces.length; ++i) {
                this.classWeights[i] = Double.valueOf(pieces[i]);
            }
            return argIndex + 2;
        }
        return argIndex;
    }
}

