/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.tagger.maxent.Distsim;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.PairsHolder;

public class ExtractorDistsimConjunction
extends Extractor {
    private static final long serialVersionUID = 1L;
    private final Distsim lexicon;
    private final int left;
    private final int right;
    private String name;

    @Override
    String extract(History h, PairsHolder pH) {
        StringBuilder sb = new StringBuilder();
        for (int j = this.left; j <= this.right; ++j) {
            String word = pH.getWord(h, j);
            String distSim = this.lexicon.getMapping(word);
            sb.append(distSim);
            if (j >= this.right) continue;
            sb.append('|');
        }
        return sb.toString();
    }

    ExtractorDistsimConjunction(String distSimPath, int left, int right) {
        this.lexicon = Distsim.initLexicon(distSimPath);
        this.left = left;
        this.right = right;
        this.name = "ExtractorDistsimConjunction(" + left + ',' + right + ')';
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

