num_iters=2
# step_size=2.0
step_size=1.0
epochs=5
batch_size=128
total_steps=5000

output_dir="../train_results/0809-TeCoA_ITR+EDA0.3/"

#########################################
##############  each aug  ###############
#########################################
aug_n=0
aug_m=0
scale=0.8

attack_list=(
    MMA
)

config_list=(
    # ./configs/ICLR/flickr30k/caps_k=1.yaml
    # ./configs/ICLR/flickr30k/caps_k=1_Caps.yaml
    # ./configs/ICLR/flickr30k/caps_k=1_EDA1234.yaml
    # ./configs/ICLR/flickr30k/caps_k=1_ImageCap1234.yaml
    # ./configs/ICLR/flickr30k/caps_k=1_Llama1234.yaml
    # ./configs/ICLR/flickr30k/caps_k=1_RandAug1234.yaml
    # ./configs/ICLR/flickr30k/caps_k=1_SD0123.yaml
    # ./configs/ICLR/flickr30k/caps_k=1_SD0123+Caps.yaml
    ./configs/ICLR/flickr30k/caps_k=1_allLangAlign25_75_diff_25_75.yaml

)
config_name_list=(
    # base
    # Caps
    # EDA1234
    # ImageCap1234
    # Llama1234
    # RandAug1234
    # SD1234
    # SD1234+Caps
    LangFiltered25_75
)

# EDA
alpha_list=(0.3)
for alpha in ${alpha_list[@]}; do

    for attack in ${attack_list[@]}; do

        for i in ${!config_list[@]}; do
            config=${config_list[$i]}
            config_name=${config_name_list[$i]}

            is_eda=False
            mark=att-${attack}_${config_name}
            if [ $alpha != 0.0 ]; then
                mark=${mark}-EDA${alpha}befAtt
                is_eda=True
            fi

            scale_ver=0
            txt_sup_k=1
            txt_aug=rand
            is_txt_aug=False

            python3 -m torch.distributed.launch --nproc_per_node=1 --use_env --master_port=$RANDOM \
                train_clip_clean.py \
                --config $config \
                --model CLIP_ViT-B-16 \
                --model_name CLIP_ViT-B-16 \
                --train_config ./configs/train/full/clip_base.yaml \
                --attack $attack \
                --step_size $step_size \
                --num_iters $num_iters \
                --scale_ver $scale_ver \
                --alpha_sr $alpha \
                --alpha_ri $alpha \
                --alpha_rs $alpha \
                --p_rd $alpha \
                --alpha_unsup 0 \
                --alpha_sup 1 \
                --output_dir $output_dir \
                --batch_size $batch_size \
                --total_steps $total_steps \
                --aug_n $aug_n \
                --aug_m $aug_m \
                --aug_scale $scale \
                --is_eda $is_eda \
                --mark $mark
        done
    done
done
