num_iters=2
# step_size=2.0
step_size=1.0
epochs=5
batch_size=128
total_steps=5000

output_dir="../train_results/0719_flickr-TeCoA/"

#########################################
##############  each aug  ###############
#########################################
aug_n=0
aug_m=0
scale=0.8

attack=MMA

config=./configs/ICLR/flickr30k/caps_k=1.yaml

train_file_1=/data/dataset/dataset_json/data_rewrite/flickr30k_train_caps=1.json

train_file_2_list=(
    # /data/dataset/dataset_json/data_filtered/caps1234_alignOver50th.json
    # /data/dataset/dataset_json/data_filtered/caps1234_alignUnder50th.json
    # /data/dataset/dataset_json/data_filtered/caps1234_distOver50th.json
    # /data/dataset/dataset_json/data_filtered/caps1234_distUnder50th.json
    /data/dataset/dataset_json/data_filtered/caps1234_alignOver50th_distOver50th.json
    /data/dataset/dataset_json/data_filtered/caps1234_alignUnder50th_distUnder50th.json
    /data/dataset/dataset_json/data_filtered/caps1234_alignOver50th_distUnder50th.json
    /data/dataset/dataset_json/data_filtered/caps1234_alignUnder50th_distOver50th.json
)

mark_list=(
    Caps_alignOver50th_distOver50th
    Caps_alignUnder50th_distUnder50th
    Caps_alignOver50th_distUnder50th
    Caps_alignUnder50th_distOver50th
)

for i in ${!train_file_2_list[@]}; do
    train_file_2=${train_file_2_list[$i]}
    mark=${mark_list[$i]}

    python3 -m torch.distributed.launch --nproc_per_node=1 --use_env --master_port=$RANDOM \
        train_clip_clean.py \
        --config $config \
        --model CLIP_ViT-B-16 \
        --model_name CLIP_ViT-B-16 \
        --train_file $train_file_1 $train_file_2 \
        --train_config ./configs/train/full/clip_base.yaml \
        --attack $attack \
        --step_size $step_size \
        --num_iters $num_iters \
        --alpha_sr 0.1 \
        --alpha_ri 0.1 \
        --alpha_rs 0.1 \
        --p_rd 0.1 \
        --alpha_unsup 0 \
        --alpha_sup 1 \
        --output_dir $output_dir \
        --batch_size $batch_size \
        --total_steps $total_steps \
        --aug_n $aug_n \
        --aug_m $aug_m \
        --aug_scale $scale \
        --mark $mark
done