#!/bin/bash
# SBATCH commands
set -euo pipefail

llms=("Qwen2.5-VL-72B-Instruct")
# "Qwen2.5-VL-7B-Instruct" "deepseek-vl2" "Llama-3.2-11B-Vision-Instruct" "Llama-3.2-90B-Vision-Instruct"

image_dirs=("benchmark/images/test1100" "benchmark/images/test1200")
# "benchmark/images/test200" "benchmark/images/test400" "benchmark/images/test600" "benchmark/images/test800" "benchmark/images/test1000" "benchmark/images/test1100" "benchmark/images/test1200"

use_heuristics=${2:-true}
use_free_form=${3:-false}

NUM_GPUS=8
export CUDA_VISIBLE_DEVICES="0,1,2,3,4,5,6,7"
export VLLM_LOGGING_LEVEL=WARNING

mkdir -p logs 

for llm in "${llms[@]}"; do
    echo "Model: $llm"
    case "$llm" in
        deepseek-vl2|Llama-3.2-11B-Vision-Instruct|Qwen2.5-VL-7B-Instruct)
            BATCH_SIZE=4
            ;;
        Llama-3.2-90B-Vision-Instruct|Qwen2.5-VL-72B-Instruct)
            BATCH_SIZE=1
            ;;
        *)
            BATCH_SIZE=2
            ;;
    esac
    python src/gen.py \
        -m "${llm}" \
        --image-dirs "${image_dirs[@]}" \
        --num-gpus ${NUM_GPUS} \
        --batch-size ${BATCH_SIZE} \
        $( [ "$use_heuristics" = true ] && echo "--include_heuristics" ) \
        $( [ "$use_free_form" = true ] && echo "--free_form" )
done