#!/bin/bash

set -euo pipefail
mkdir -p logs

image_dirs=("benchmark/images/test200" "benchmark/images/test400" "benchmark/images/test600" "benchmark/images/test800" "benchmark/images/test1000" "benchmark/images/test1100" "benchmark/images/test1200")
llms=("claude-sonnet-4-20250514") # "gemini-2.5-flash" "claude-sonnet-4-20250514" "gpt-5" "o3" "o4-mini" "gpt-4o" "gpt-4.1" "gpt-4.1-mini" "Llama-4-Maverick-17B-128E-Instruct-FP8"
method="malicious" # "zs" "iter-cot" "malicious"

# group args
use_heuristics=false
use_free_form=true
q7_only=false
explicit_granularity=false  # Enable explicit-granularity mode (asks for granularity assessment only, no geolocation)

for image_dir in "${image_dirs[@]}"; do
    for llm in "${llms[@]}"; do
        echo "Model: $llm"
        # Provider-specific flags
        extra_flags=()
        # batch processing for claude
        if [[ "$llm" == claude-* ]]; then
            extra_flags+=(--claude-batch --claude-batch-size 50)
        fi
        # Azure is required for granularity when free-form
        azure_flag=(--use-azure)

        python src/api_gen.py \
            -m "${llm}" \
            --image-dir "${image_dir}" \
            --prompting-method "${method}" \
            --n-threads 2 \
            "${azure_flag[@]}" \
            --max-examples 200 \
            "${extra_flags[@]}" \
            $( [ "$use_heuristics" = true ] && echo "--include-heuristics" ) \
            $( [ "$use_free_form" = true ] && echo "--free-form" ) \
            $( [ "$q7_only" = true ] && echo "--q7-only" ) \
            $( [ "$explicit_granularity" = true ] && echo "--explicit-granularity" )
    done
done