Graph in Graph Neural Network
=
This is a paper under review by ICLR 2023  
> 
> **"Graph in Graph Neural Network"**, 
> **ICLR 2023**
> 
> [[Paper]](https://) [[Project]](https://)
> 
> __Abstract:__ Most existing Graph Neural Networks (GNNs) frequently suffer from two limita-
tions: (i) they can only process graphs whose vertices are represented by vectors
or single values; and (ii) they assume each input graph is independent from others
during the propagation. In this paper, we propose the first GNN model (called
Graph in Graph Neural Network (GIG)) that can process graphs whose ver-
tices are also represented by graphs. Considering that the relationship between
different graphs may contain crucial task-related cues, we further propose a GIG
graph relationship modelling (GRM) strategy that integrates multiple target graph
samples as a global graph, each of whose vertex describes a target graph sample.
We then applies the GIG model to jointly process the combined graph samples
(i.e., the global graph), where additional task-specific relationship cues among
graph samples can be extracted in an end-to-end manner. The experimental re-
sults show that the proposed GIG model and the GRM strategy generalize well on
various graph analysis tasks, providing new state-of-the-art results on five out of
seven benchmark graph datasets. Importantly, not only its vertex/edge updating
functions are flexible to be customized from different existing GNNs but also it
is robust to different settings. Our code is provided in the supplementary material
for reproducibly purpose.


<p align="center">
<img src="img/overall.png" width="90%" />
</p>

>We adopted datasets and codes for processing datasets from Benchmarking Graph Neural Networks(https://github.com/graphdeeplearning/benchmarking-gnns#benchmarking-graph-neural-networks)





🔧 Requirements
=
- Python 3.8
- PyTorch 1.9.0
- CUDA 11.1
- DGL 0.9.0

- Check the required python packages in `dependency.txt`.
```
pip install -r dependency.txt
```

Data and Data Prepareing Tools
=
The Datasets we used:
  * [MNIST](https://data.dgl.ai/dataset/benchmarking-gnns/MNIST.pkl)
  * [CIFAR10](https://data.dgl.ai/dataset/benchmarking-gnns/CIFAR10.pkl)
  * [PATTERN](https://data.dgl.ai/dataset/benchmarking-gnns/SBM_PATTERN.pkl)
  * [CLUSTER](https://data.dgl.ai/dataset/benchmarking-gnns/SBM_CLUSTER.pkl)
  * [ZINC](https://data.dgl.ai/dataset/benchmarking-gnns/ZINC.pkl)
  * [AQSOL](https://www.dropbox.com/s/x1ej77z6peqpk2t/AQSOL.pkl?dl=1)
  * [TSP](https://data.dgl.ai/dataset/benchmarking-gnns/TSP.pkl)

We provide tools for prepareing data in ```data/```.
After Downloading raw data files, you can use data processing codes in corresponding folders to process raw data.
More details have been described in [data/README.md](data/README.md).


Training and Testing
= 
>All experiments were organized in Jupyter Notebook. To train the model for each dataset, corresponding notebook file should be run from the starting block to the end.

  * MNIST
    * Run all code blocks in `GIG_MNIST.ipynb` 

  * CIFAR10
    * Run all code blocks in `GIG_CIFAR10.ipynb`   

  * CLUSTER
    * Run all code blocks in `GIG_CLUSTER.ipynb` 

  * PATTERN
    * Run all code blocks in `GIG_PATTERN.ipynb` 
   
  * ZINC
    * Run all code blocks in `GIG_ZINC.ipynb` 

  * AQSOL
    * Run all code blocks in `GIG_AQSOL.ipynb` 
  
  * TSP
    * Run all code blocks in `GIG_TSP.ipynb` 


Trained weights
=
> All trained weights have been placed in ```weights/```. You can find weight file of each dataset in corresponding folder according to the name of the dataset.


📝 Main Results
=
|   Method  | MNIST | CIFAR10 | ZINC    | AQSOL   |PATTERN|CLUSTER| TSP   |
| :-------: | :---: | :---:   | :---:   | :---:   | :---: | :---: | :---: | 
|    GCN    | 90.12 | 54.14   | 0.278   |  1.333  | 85.61 |69.03  |0.643  |
|    GIN    | 96.49 | 55.26   | 0.387   |1.894    |85.59  |64.72  |0.656  |
|    GAT    | 95.54 | 64.22   | 0.384   |1.403    |78.27  |70.59  |0.671  |
|  GatedGCN | 97.34 | 67.31   | 0.214   | 0.996   | 86.51 |76.08  |0.838  |
|    PNA    | 97.94 | 70.86   | 0.188   | -       | 86.57 | -     | -     |
|    DGN    | -     | 72.84   | 0.168   | -       | 86.68 | -     | -     |
|    EGT    | 98.17 | 68.70   | 0.108   | -       | 86.82 | 79.23 | 0.853 |
|   ARGNP   |   -   | 73.90   | 0.136   | -       | -     | 77.35 | 0.855 |   
|  GNAS-MP  | 98.01 | 70.10   | 0.242   | -       | 86.80 | 62.21 | -     |      
|  GIG(Ours)| 98.72 | 75.66   | 0.157   | 0.975   | 86.82 | 78.95 | 0.860 |


🎓 Citation
=
if the code or method help you in the research, please cite the following paper:
```


```
