import argparse
import torch
import json


def get_args():
    parser = argparse.ArgumentParser(description='ESPD')

    parser.add_argument('--env_name',
                        default='FetchPush-v1',
                        help='environment name (default: FetchPush-v1)')
    parser.add_argument('--num_env',default= 1,type=int)
    parser.add_argument('--seed',
                        type=int,
                        default=1234,
                        help='seed (default: 1234)')
    parser.add_argument('--num_episode',
                        type=int,
                        default=250,
                        help='number of episode to run (default: 600)')
    parser.add_argument('--batch-size',
                        type=int,
                        default=50,
                        help='batch size (default: 2500)')
    parser.add_argument('--max-step-per-round',
                        default=50,
                        type=int,
                        help='maximum number of steps (default: 200)')
    parser.add_argument('--gamma',
                        type=float,
                        default=0.995,
                        help='descount factor (default: 0.995)')
    parser.add_argument('--log-num-episode',
                        type=float,
                        default=1,
                        help='print log after number of episodes (default: 1)')
    parser.add_argument('--num-epoch',
                        type=int,
                        default=30,
                        help='number of epoch (default: 30)')
    parser.add_argument('--minibatch-size',
                        type=int,
                        default=25,
                        help='batch size (default: 25)')
    parser.add_argument('--clip',
                        type=float,
                        default=0.2,
                        help='clip gradient (default: 0.2)')
    parser.add_argument('--factor', default=1.0,
                        help='Exploration rate (default: 1.0)')
    parser.add_argument('--lr-hid', default=3e-4,
                        help='Learning rate (default: 3e-4)')
    parser.add_argument('--Horizon-max',
                        default=10,
                        help='maximum horizon (default: 10)')
    parser.add_argument('--reward-pos', default=0.,
                        help='reward for success')

    parser.add_argument('--num-parallel-run',
                        default=1,
                        help='number of parallel to train')
    
    # tricks
    parser.add_argument('--layer-norm',
                        default=True,
                        help='layer normalization (default: True)')
    parser.add_argument('--replay-buffer-size-IER',
                        default=100000,
                        help='replay buffer size (default: 100000)')

    
    # Others
    parser.add_argument('--NOTTESTFUNCTION',
                        action="store_true",
                        help='Whether to not use SELECT function.(default: False)')
    parser.add_argument('--plot',
                        action="store_true",
                        help='Whether to plot the trajectories (default: False)')                                 
    parser.add_argument('--name',
                        default='Demo',type =str,
                        help='Name for storage')
    parser.add_argument('--rank',type = int, default = 0,help='Increasement on Seed every Episode (default: 0)')
    parser.add_argument('--algo',default="SPLID", help='name of algorithm')
    
    args = parser.parse_args()
    args.cuda = torch.cuda.is_available()
    print(args)
    return args
