"""config parameters
each test should input 4 params:
1. mode ('classify' or 'regression')
2. c_columns: continous columns names type: list of strs
3. d_columns: discrete columns names  type: list of strs
4. target: data target name type: list of strs
e.g. like configs['adult']"""
import os

path = os.path.dirname(os.path.realpath(__file__))

configs = {
    "adult": {"mode": "classify",
              "c_columns": ['age', 'fnlwgt', 'earnings', 'loss', 'hour', 'edu_nums'],
              "d_columns": ['work_cate', 'education', 'marital', 'profession', 'relation', 'race', 'gender',
                            'motherland'],
              "target": "label",
              "model": "lr",
              "dataset_path": fr"{path}/data/adult.csv",
              "metric": "auc"},
    "medical_charges": {"mode": "regression",
                        "c_columns": ['Total_Discharges', 'Average_Covered_Charges', 'Average_Medicare_Payments'],
                        "d_columns": ['DRG_Definition', 'Provider_Id', 'Provider_Name', 'Provider_Street_Address',
                                      'Provider_City', 'Provider_State', 'Provider_Zip_Code',
                                      'Hospital_Referral_Region_(HRR)_Description'],
                        "target": "Average_Total_Payments",
                        "model": "rf",
                        "dataset_path": fr"{path}/data/medical_charges_nominal.csv",
                        "metric": "rae"},
    "GiveMeCredit": {"mode": "classify",
                     "c_columns": ['RevolvingUtilizationOfUnsecuredLines', 'age',
                                   'NumberOfTime30-59DaysPastDueNotWorse', 'DebtRatio', 'MonthlyIncome',
                                   'NumberOfOpenCreditLinesAndLoans', 'NumberOfTimes90DaysLate',
                                   'NumberRealEstateLoansOrLines', 'NumberOfTime60-89DaysPastDueNotWorse',
                                   'NumberOfDependents'],
                     "d_columns": [],
                     "target": "SeriousDlqin2yrs",
                     "model": "lr",
                     "dataset_path": fr"{path}/data/give_me_credit.csv",
                     "metric": "auc"},
    "house_kc": {"mode": "regression",
                 "c_columns": ['bedrooms', 'bathrooms', 'sqft_living', 'sqft_lot', 'sqft_above', 'sqft_basement', 'lat',
                               'long', 'sqft_living15', 'sqft_lot15'],
                 "d_columns": ['year', 'month', 'day', 'floors', 'waterfront', 'view', 'condition', 'grade', 'yr_built',
                               'yr_renovated', 'zipcode'],
                 "target": "price",
                 "model": "rf",
                 "dataset_path": fr"{path}/data/kc_house.csv",
                 "metric": "rae"},

    "default_credit_card": {'mode': 'classify',
                            'c_columns': ['LIMIT_BAL', 'AGE', 'BILL_AMT1', 'BILL_AMT2',
                                          'BILL_AMT3', 'BILL_AMT4', 'BILL_AMT5', 'BILL_AMT6',
                                          'PAY_AMT1', 'PAY_AMT2', 'PAY_AMT3', 'PAY_AMT4',
                                          'PAY_AMT5', 'PAY_AMT6'],
                            'd_columns': ['SEX', 'EDUCATION', 'MARRIAGE', 'PAY_0', 'PAY_2',
                                          'PAY_3', 'PAY_4', 'PAY_5', 'PAY_6'],
                            'target': 'target',
                            "model": "rf",
                            "dataset_path": fr"{path}/data/default_credit_card.csv",
                            "metric": "f1"},
    "credit_a": {'mode': 'classify',
                 'c_columns': ['A2', 'A3', 'A8', 'A11', 'A14', 'A15'],
                 'd_columns': ['A1', 'A4', 'A5', 'A6', 'A7', 'A9', 'A10', 'A12', 'A13'],
                 'target': 'label',
                 "model": "lr",
                 "dataset_path": fr"{path}/data/credit_a.csv",
                 "metric": "f1"},
    "ionosphere": {'mode': 'classify',
                   'c_columns': ['C1', 'C2', 'C3', 'C4', 'C5', 'C6', 'C7', 'C8', 'C9', 'C10', 'C11', 'C12',
                                 'C13', 'C14', 'C15', 'C16', 'C17', 'C18', 'C19', 'C20', 'C21', 'C22', 'C23',
                                 'C24', 'C25', 'C26', 'C27', 'C28', 'C29', 'C30', 'C31', 'C32'],
                   'd_columns': ['D1', 'D2'],
                   'target': 'label',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/ionosphere.csv",
                   "metric": "f1"},
    "messidor_features": {'mode': 'classify',
                          'c_columns': ['C1', 'C2', 'C3', 'C4', 'C5', 'C6', 'C7', 'C8', 'C9', 'C10', 'C11', 'C12',
                                        'C13', 'C14', 'C15', 'C16'],
                          'd_columns': ['D1', 'D2', 'D3'],
                          'target': 'label',
                          "model": "lr",
                          "dataset_path": fr"{path}/data/messidor_features.csv",
                          "metric": "f1"},
    "PimaIndian": {'mode': 'classify',
                   'c_columns': ['C0', 'C1', 'C2', 'C3', 'C4', 'C5', 'C6', 'C7'],
                   'd_columns': [],
                   'target': 'label',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/PimaIndian.csv",
                   "metric": "f1"},
    'winequality-red': {'mode': 'classify',
                        'c_columns': ['fixed acidity', 'volatile acidity', 'citric acid',
                                      'residual sugar', 'chlorides', 'free sulfur dioxide',
                                      'total sulfur dioxide', 'density', 'pH', 'sulphates',
                                      'alcohol'],
                        'd_columns': [],
                        'target': 'quality',
                        "model": "lr",
                        "dataset_path": fr"{path}/data/winequality-red.csv",
                        "metric": "f1"},
    'winequality-white': {'mode': 'classify',
                          'c_columns': ['fixed acidity', 'volatile acidity', 'citric acid',
                                        'residual sugar', 'chlorides', 'free sulfur dioxide',
                                        'total sulfur dioxide', 'density', 'pH', 'sulphates',
                                        'alcohol'],
                          'd_columns': [],
                          'target': 'quality',
                          "model": "lr",
                          "dataset_path": fr"{path}/data/winequality-white.csv",
                          "metric": "f1"},
    'SPECTF': {'mode': 'classify',
               'c_columns': ['V0', 'V1', 'V2', 'V3', 'V4', 'V5', 'V6', 'V7', 'V8', 'V9', 'V10', 'V11', 'V12', 'V13',
                             'V14', 'V15', 'V16', 'V17', 'V18', 'V19', 'V20', 'V21', 'V22', 'V23', 'V24', 'V25', 'V26',
                             'V27', 'V28', 'V29', 'V30', 'V31', 'V32', 'V33', 'V34', 'V35', 'V36', 'V37', 'V38', 'V39',
                             'V40', 'V41', 'V42', 'V43'],
               'd_columns': [],
               'target': 'label',
               "model": "lr",
               "dataset_path": fr"{path}/data/SPECTF.csv",
               "metric": "f1"},
    'hepatitis': {'mode': 'classify',
                  'c_columns': ['V0', 'V13', 'V14', 'V15', 'V16', 'V17'],
                  'd_columns': ['V1', 'V2', 'V3', 'V4', 'V5', 'V6', 'V7', 'V8', 'V9', 'V10', 'V11', 'V12', 'V18'],
                  'target': 'label',
                  "model": "lr",
                  "dataset_path": fr"{path}/data/hepatitis.csv",
                  "metric": "f1"},
    'megawatt1': {'mode': 'classify',
                  'c_columns': ['a', 'b', 'c', 'e', 'f', 'g', 'h', 'i', 'j', 'k',
                                'l', 'm', 'n', 'p', 's', 't', 'u', 'v', 'z',
                                'aa', 'ab', 'ac', 'ad', 'ae', 'af', 'ag', 'ah', 'ai', 'aj',
                                'ak', 'al', 'am', 'an', 'ao'],
                  'd_columns': ['d', 'o', 'r'],
                  'target': 'def',
                  "model": "lr",
                  "dataset_path": fr"{path}/data/megawatt1.csv",
                  "metric": "f1"},
    'fertility_Diagnosis': {'mode': 'classify',
                            'c_columns': ['V1', 'V6', 'V8'],
                            'd_columns': ['V0', 'V2', 'V3', 'V4', 'V5', 'V7'],
                            'target': 'label',
                            "model": "lr",
                            "dataset_path": fr"{path}/data/fertility.csv",
                            "metric": "f1"},
    'spambase': {'mode': 'classify',
                 'c_columns': ['V0', 'V1', 'V2', 'V3', 'V4', 'V5', 'V6', 'V7', 'V8', 'V9', 'V10',
                               'V11', 'V12', 'V13', 'V14', 'V15', 'V16', 'V17', 'V18', 'V19', 'V20',
                               'V21', 'V22', 'V23', 'V24', 'V25', 'V26', 'V27', 'V28', 'V29', 'V30',
                               'V31', 'V32', 'V33', 'V34', 'V35', 'V36', 'V37', 'V38', 'V39', 'V40',
                               'V41', 'V42', 'V43', 'V44', 'V45', 'V46', 'V47', 'V48', 'V49', 'V50',
                               'V51', 'V52', 'V53', 'V54', 'V55', 'V56'],
                 'd_columns': [],
                 'target': 'label',
                 "model": "lr",
                 "dataset_path": fr"{path}/data/spambase.csv",
                 "metric": "f1"},
    'german_credit_24': {'mode': 'classify',
                         'c_columns': ['C0', 'C1', 'C2'],
                         'd_columns': ['V0', 'V1', 'V2', 'V3', 'V4', 'V5', 'V6', 'V7', 'V8', 'V9', 'V10', 'V11', 'V12',
                                       'V13', 'V14', 'V15', 'V16', 'V17', 'V18', 'V19', 'V20'],
                         'target': 'label',
                         "model": "lr",
                         "dataset_path": fr"{path}/data/german_credit_24.csv",
                         "metric": "f1"
                         },
    'Bikeshare_DC': {'mode': 'regression',
                     'c_columns': ['temp', 'atemp', 'humidity', 'windspeed', 'casual',
                                   'registered'],
                     'd_columns': ['season', 'holiday', 'weekday', 'workingday', 'weather'],
                     'target': 'count',
                     "model": "lr",
                     "dataset_path": fr"{path}/data/Bikeshare_DC.csv",
                     "metric": "rae"
                     },
    'airfoil': {'mode': 'regression',
                'c_columns': ['V0', 'V1', 'V2', 'V3', 'V4'],
                'd_columns': [],
                'target': 'label',
                "model": "lr",
                "dataset_path": fr"{path}/data/airfoil.csv",
                "metric": "rae"
                },
    'Housing_Boston': {'mode': 'regression',
                       'c_columns': ['V0', 'V1', 'V2', 'V4', 'V5', 'V6',
                                     'V7', 'V8', 'V9', 'V10', 'V11', 'V12'],
                       'd_columns': ['V3'],
                       'target': 'label',
                       "model": "lr",
                       "dataset_path": fr"{path}/data/Housing_Boston.csv",
                       "metric": "rae"
                       },
    'lymphography': {'mode': 'classify',
                     'c_columns': ['V0', 'V1', 'V2', 'V3', 'V4', 'V5', 'V6',
                                   'V7', 'V8', 'V9', 'V10', 'V11', 'V12', 'V13', 'V14', 'V15', 'V16', 'V17'],
                     'd_columns': [],
                     'target': 'label',
                     "model": "lr",
                     "dataset_path": fr"{path}/data/lymphography.csv",
                     "metric": "rae"
                     },
    'Openml_586': {'mode': 'regression',
                   'c_columns': ['oz1', 'oz2', 'oz3', 'oz4', 'oz5', 'oz6', 'oz7', 'oz8', 'oz9', 'oz10',
                                 'oz11', 'oz12', 'oz13', 'oz14', 'oz15', 'oz16', 'oz17', 'oz18', 'oz19',
                                 'oz20', 'oz21', 'oz22', 'oz23', 'oz24', 'oz25'],
                   'd_columns': [],
                   'target': 'oz26',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/Openml_586.csv",
                   "metric": "rae"
                   },
    'Openml_589': {'mode': 'regression',
                   'c_columns': ['oz1', 'oz2', 'oz3', 'oz4', 'oz5', 'oz6', 'oz7', 'oz8', 'oz9', 'oz10',
                                 'oz11', 'oz12', 'oz13', 'oz14', 'oz15', 'oz16', 'oz17', 'oz18', 'oz19',
                                 'oz20', 'oz21', 'oz22', 'oz23', 'oz24', 'oz25'],
                   'd_columns': [],
                   'target': 'oz26',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/Openml_589.csv",
                   "metric": "rae"
                   },
    'Openml_607': {'mode': 'regression',
                   'c_columns': ['oz1', 'oz2', 'oz3', 'oz4', 'oz5', 'oz6', 'oz7', 'oz8',
                                 'oz9', 'oz10', 'oz11', 'oz12', 'oz13', 'oz14', 'oz15',
                                 'oz16', 'oz17', 'oz18', 'oz19', 'oz20', 'oz21', 'oz22',
                                 'oz23', 'oz24', 'oz25', 'oz26', 'oz27', 'oz28', 'oz29',
                                 'oz30', 'oz31', 'oz32', 'oz33', 'oz34', 'oz35', 'oz36',
                                 'oz37', 'oz38', 'oz39', 'oz40', 'oz41', 'oz42', 'oz43',
                                 'oz44', 'oz45', 'oz46', 'oz47', 'oz48', 'oz49', 'oz50',
                                 ],
                   'd_columns': [],
                   'target': 'oz51',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/Openml_607.csv",
                   "metric": "rae"
                   },
    'Openml_616': {'mode': 'regression',
                   'c_columns': ['oz1', 'oz2', 'oz3', 'oz4', 'oz5', 'oz6', 'oz7', 'oz8', 'oz9', 'oz10',
                                 'oz11', 'oz12', 'oz13', 'oz14', 'oz15', 'oz16', 'oz17', 'oz18', 'oz19',
                                 'oz20', 'oz21', 'oz22', 'oz23', 'oz24', 'oz25', 'oz26', 'oz27', 'oz28',
                                 'oz29', 'oz30', 'oz31', 'oz32', 'oz33', 'oz34', 'oz35', 'oz36', 'oz37',
                                 'oz38', 'oz39', 'oz40', 'oz41', 'oz42', 'oz43', 'oz44', 'oz45', 'oz46',
                                 'oz47', 'oz48', 'oz49', 'oz50'],
                   'd_columns': [],
                   'target': 'oz51',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/Openml_616.csv",
                   "metric": "rae"
                   },
    'Openml_618': {'mode': 'regression',
                   'c_columns': ['oz1', 'oz2', 'oz3', 'oz4', 'oz5', 'oz6', 'oz7', 'oz8', 'oz9',
                                 'oz10', 'oz11', 'oz12', 'oz13', 'oz14', 'oz15', 'oz16', 'oz17',
                                 'oz18', 'oz19', 'oz20', 'oz21', 'oz22', 'oz23', 'oz24', 'oz25',
                                 'oz26', 'oz27', 'oz28', 'oz29', 'oz30', 'oz31', 'oz32', 'oz33',
                                 'oz34', 'oz35', 'oz36', 'oz37', 'oz38', 'oz39', 'oz40', 'oz41',
                                 'oz42', 'oz43', 'oz44', 'oz45', 'oz46', 'oz47', 'oz48', 'oz49', 'oz50'],
                   'd_columns': [],
                   'target': 'oz51',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/Openml_618.csv",
                   "metric": "rae"
                   },
    'Openml_620': {'mode': 'regression',
                   'c_columns': ['oz1', 'oz2', 'oz3', 'oz4', 'oz5', 'oz6', 'oz7', 'oz8', 'oz9', 'oz10', 'oz11',
                                 'oz12', 'oz13', 'oz14', 'oz15', 'oz16', 'oz17', 'oz18', 'oz19', 'oz20', 'oz21',
                                 'oz22', 'oz23', 'oz24', 'oz25'],
                   'd_columns': [],
                   'target': 'oz26',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/Openml_620.csv",
                   "metric": "rae"
                   },
    'Openml_637': {'mode': 'regression',
                   'c_columns': ['oz1', 'oz2', 'oz3', 'oz4', 'oz5', 'oz6', 'oz7', 'oz8', 'oz9', 'oz10', 'oz11',
                                 'oz12', 'oz13', 'oz14', 'oz15', 'oz16', 'oz17', 'oz18', 'oz19', 'oz20', 'oz21',
                                 'oz22', 'oz23', 'oz24', 'oz25', 'oz26', 'oz27', 'oz28', 'oz29', 'oz30', 'oz31',
                                 'oz32', 'oz33', 'oz34', 'oz35', 'oz36', 'oz37', 'oz38', 'oz39', 'oz40', 'oz41',
                                 'oz42', 'oz43', 'oz44', 'oz45', 'oz46', 'oz47', 'oz48', 'oz49', 'oz50'],
                   'd_columns': [],
                   'target': 'oz51',
                   "model": "lr",
                   "dataset_path": fr"{path}/data/Openml_637.csv",
                   "metric": "rae"
                   },

    'amazon_employee': {'mode': 'classify',
                        'c_columns': ['RESOURCE', 'MGR_ID', 'ROLE_ROLLUP_1', 'ROLE_ROLLUP_2', 'ROLE_DEPTNAME', 'ROLE_TITLE', 'ROLE_FAMILY_DESC', 'ROLE_FAMILY',
                                      'ROLE_CODE'],
                        'd_columns': [],
                        'target': 'ACTION',
                        'model': 'xgb',
                        "dataset_path": fr"{path}/data/amazon_employee.csv",
                        'metric': 'auc'
                        },

    "poker_hand": {"mode": "classify",
                   "c_columns": ['C1', 'C2', 'C3', 'C4', 'C5'],
                   "d_columns": ['S1', 'S2', 'S3', 'S4', 'S5'],
                   "target": "CLASS",
                   "model": "rf",
                   "dataset_path": fr"{path}/data/poker_hand.csv",
                   "metric": "rae"},
}
