from datetime import datetime

from concurrent import futures
from copy import deepcopy

import numpy as np
import pandas as pd

from models.NoisyDualMD_LP import NoisyDualMD
from models.utils import read_problem


def Run():
    for vareps in [1, 2, 5, 10]:  # 1, 2, 5, 10, 20
        for delta in [0.01]:
            for K_multiplier in [1.1]:  # 1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.8, 2
                for update_rule in ['projected_gd_positive']:  # 'md_ne', 'md_ne_parameterized', 'md_l2', 'gd', 'projected_gd', 'projected_gd_positive'
                    '''
                    Problem options:
                    workforce_scheduling_gurobi_demo: a scheduling problem from Gurobi demo
                    assignp800:                       assignment problem with 800 agents, 800 services, 10 types of resource
                    assignp1500:                      assignment problem with 1500 agents, 1500 services, 10 types of resource
                    assignp3000:                      assignment problem with 3000 agents, 3000 services, 10 types of resource
                    '''
                    problem = 'workforce_scheduling_gurobi_demo'
                    exp_params = read_problem(problem, 0.1)
                    exp_params.update({'problem': problem})
                    
                    # -----
                    n, m, s = exp_params['n'], exp_params['m'], exp_params['s']

                    obj_coeffs = np.asarray([request[0] for request in exp_params['requests']])
                    dual_bd = np.sum(np.sort(np.max(obj_coeffs, axis=0))[-8:])

                    algo_params = {'update_rule': update_rule,
                                   'dual_bd': dual_bd,
                                   'K_multiplier': K_multiplier,
                                   'dual_bd_for_p_init': True,
                                   'p_init': None,
                                   'T': 10000,
                                   'private': 1,       # 0=non-private, 1=our-algo, 2=2017JPCvx
                                   'batch_size': 100,  # batch size affects logs only.
                                   'vareps': vareps,
                                   'delta': delta,

                                   # misc params
                                   'ftol': 1e-12,
                                   'log_suffix': '_prefavg'  # suffix options: _onebatchavg, _prefavg
                                   }

                    # -- construct tasks
                    iters = 50
                    tasks = []
                    for iteration in range(iters):
                        tasks.append(NoisyDualMD(exp_params, algo_params))

                    print(f'--- {iters} experiments to run --- (vareps,delta)={vareps,delta} --- gamma= --- rule={update_rule}')
                    try:
                        with futures.ProcessPoolExecutor(max_workers=1) as executor:
                            tasks = [executor.submit(tasks[i].Run) for i, _ in enumerate(tasks)]
                            for k, task in enumerate(futures.as_completed(tasks)):
                                task_return = task.result()
                                print(f'----{k}----' + 'Done----')
                    except Exception as error:
                        print(error)


if __name__ == '__main__':
    Run()




