import time

import numpy as np
from gurobipy import quicksum
import gurobipy as grb




class GRB_Model(object):
    def __init__(self, exp_params, algo_params):
        self.x = None
        self.algo_params = algo_params
        self.exp_params = exp_params
        for k, v in algo_params.items():
            setattr(self, k, v)
        for k, v in exp_params.items():
            setattr(self, k, v)
        self.ngamma = self.n * self.gamma

    def Solve_x_p(self):
        # -- Declare model
        model = grb.Model()
        model.setParam('OutputFlag', 0)

        # -- Decision Variable
        x = model.addMVar((self.n, self.s), name='x', lb=self.indiv_assign_lbs, ub=self.indiv_assign_ubs)  # default: [0,1]

        # -- Constraints
        model.addConstr(quicksum([request[1] @ x[i, :] for i, request in enumerate(self.requests)])
                        <= self.ngamma * self.b, name='coupling_constr')   # coupling constraints
        model.addConstr(x.sum(axis=1) <= self.indiv_totalassign_ubs)
        model.addConstr(x.sum(axis=1) >= self.indiv_totalassign_lbs)

        # -- Obj
        model.setObjective(quicksum([request[0] @ x[i, :] for i, request in enumerate(self.requests)]), grb.GRB.MAXIMIZE)
        model.optimize()

        prices = np.asarray([model.getConstrByName('coupling_constr[%s]' % j).Pi for j in range(self.m)])
        x = x.x
        obj = model.ObjVal
        return x, prices, obj


if __name__ == '__main__':
    # from utils import read_assignp
    # requests = read_assignp('workforce_scheduling/data/assignp800.txt')
    # m, n = requests[0][1].shape[0], len(requests)
    # s = m
    # vareps, delta = 1, 0.01
    # exp_params = {'m': m,
    #               'n': n,
    #               's': s,
    #               'gamma': 1/n,
    #               'requests': requests,
    #               'vareps': vareps,
    #               'delta': delta,
    #               'b': np.ones(m)
    # }
    #
    # K = 2 * 50 / 0.7 / 1
    # algo_params = {'potential_func': 'negative_entropy',
    #                'K': K,
    #                'alpha': 1/K,
    #                'p_init': 50 / m * np.ones(m),
    #                'T': 10000}
    #
    # t = time.time()
    # cvx_problem = GRB_Model(exp_params, algo_params)
    # x, p = cvx_problem.Solve_x_p()
    # print(f'solving time: {time.time() - t}')
    # print(x)
    # print(p)
    pass












