#!/bin/bash
session="$1"
device="$2"
environment=${7:-"Mahdi"}

file_path="exp_configs/CIFAR100_CNN/algorithm/fedyogi.sh"

algorithm="fedyogi"

norm_methods_per_layer=${3:-"[c1,c1,c1,c1]"}


tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window '2class_50clients_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$algorithm_$session $device '50_clients_class_per_client_2_Full' 50 0.1 1  $norm_methods_per_layer $4 $5 $6" C-m

window=1
tmux new-window -t $session:$window -n '2class_50clients_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$algorithm_$session $device '50_clients_class_per_client_2_Full' 50 0.01 10  $norm_methods_per_layer $4 $5 $6" C-m

window=2
tmux new-window -t $session:$window -n '2class_50clients_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 20step_fedavg_$algorithm_$session $device '50_clients_class_per_client_2_Full' 50 0.01 20  $norm_methods_per_layer $4 $5 $6" C-m

window=3
tmux new-window -t $session:$window -n '5class_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$algorithm_$session $device '20_clients_class_per_client_5_Full' 20 0.1 1  $norm_methods_per_layer $4 $5 $6" C-m

window=4
tmux new-window -t $session:$window -n '5class_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$algorithm_$session $device '20_clients_class_per_client_5_Full' 20 0.01 10  $norm_methods_per_layer $4 $5 $6" C-m

window=5
tmux new-window -t $session:$window -n '5class_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 20step_fedavg_$algorithm_$session $device '20_clients_class_per_client_5_Full' 20 0.01 20  $norm_methods_per_layer $4 $5 $6" C-m

window=6
tmux new-window -t $session:$window -n 'dirchilet_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$algorithm_$session $device '20_clients_dirichlet_0.01_full' 20 0.1 1  $norm_methods_per_layer $4 $5 $6" C-m

window=7
tmux new-window -t $session:$window -n 'dirchilet_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$algorithm_$session $device '20_clients_dirichlet_0.01_full' 20 0.01 10  $norm_methods_per_layer $4 $5 $6" C-m

window=8
tmux new-window -t $session:$window -n 'dirchilet_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 20step_fedavg_$algorithm_$session $device '20_clients_dirichlet_0.01_full' 20 0.01 20  $norm_methods_per_layer $4 $5 $6" C-m


tmux attach-session -t $session