#!/bin/bash
session="$1"
device="$2"
method="$3"          #e.g. [c1,c1,c1,v]
environment=${7:-"Mahdi"}


tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window '1class_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 1step_fedavg_$method_$session $2 '1class_full' 0.01 1 $method $4 $5 $6" C-m

window=1
tmux new-window -t $session:$window -n '1class_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 10step_fedavg_$method_$session $2 '1class_full' 0.01 10 $method $4 $5 $6" C-m

window=2
tmux new-window -t $session:$window -n '1class_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 20step_fedavg_$method_$session $2 '1class_full' 0.01 20 $method $4 $5 $6" C-m

window=3
tmux new-window -t $session:$window -n '2class_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 1step_fedavg_$method_$session $2 '2class_full' 0.01 1 $method $4 $5 $6" C-m

window=4
tmux new-window -t $session:$window -n '2class_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 10step_fedavg_$method_$session $2 '2class_full' 0.01 10 $method $4 $5 $6" C-m

window=5
tmux new-window -t $session:$window -n '2class_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 20step_fedavg_$method_$session $2 '2class_full' 0.01 20 $method $4 $5 $6" C-m

window=6
tmux new-window -t $session:$window -n 'dirchilet_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 1step_fedavg_$method_$session $2 'dirichlet_0.1_full' 0.01 1 $method $4 $5 $6" C-m

window=7
tmux new-window -t $session:$window -n 'dirchilet_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 10step_fedavg_$method_$session $2 'dirichlet_0.1_full' 0.01 10 $method $4 $5 $6" C-m

window=8
tmux new-window -t $session:$window -n 'dirchilet_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". exp_configs/CIFAR10_CNN/algorithm/fedavg.sh 20step_fedavg_$method_$session $2 'dirichlet_0.1_full' 0.01 20 $method $4 $5 $6" C-m


tmux attach-session -t $session