#!/bin/bash
session="$1"
environment=${7:-"Mahdi"}

file_path="exp_configs/CIFAR10_ResNet/centralized/main.sh"


tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window 'vanilla'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path Resnet_centralized_plot_vanilla " C-m

window=1
tmux new-window -t $session:$window -n 'BN'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path Resnet_centralized_plot_bn  'batch_norm' --affine " C-m

window=2
tmux new-window -t $session:$window -n 'LN'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path Resnet_centralized_plot_ln  'group_norm_after' --affine " C-m

window=3
tmux new-window -t $session:$window -n 'GN'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path Resnet_centralized_plot_gn 'group_norm_after' --affine --num_groups=2" C-m

window=4
tmux new-window -t $session:$window -n 'FN'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path Resnet_centralized_plot_fn 'N_prime' " C-m


tmux attach-session -t $session