#!/bin/bash
session="$1"
device="$2"
method="$3"          #e.g. "[c1,c1,c1,v]"
environment=${7:-"Mahdi"}

file_path="exp_configs/TinyImageNet_ResNet/algorithm/fedavg.sh"


tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window '1class_1step_lr0.01'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_lr0.01_$method_$session $2 '20_clients_dirichlet_0.01' 0.01 1 $method $4 $5 $6" C-m

window=1
tmux new-window -t $session:$window -n '1class_1step_lr0.1'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_lr0.1_$method_$session $2 '20_clients_dirichlet_0.01' 0.1 1 $method $4 $5 $6" C-m

window=2
tmux new-window -t $session:$window -n '1class_1step_lr0.5'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_lr0.5_$method_$session $2 '20_clients_dirichlet_0.01' 0.5 1 $method $4 $5 $6" C-m

window=3
tmux new-window -t $session:$window -n '1class_1step_lr1'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_lr1_$method_$session $2 '20_clients_dirichlet_0.01' 1 1 $method $4 $5 $6" C-m

window=4
tmux new-window -t $session:$window -n '1class_1step_lr2'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_lr2_$method_$session $2 '20_clients_dirichlet_0.01' 2 1 $method $4 $5 $6" C-m

window=5
tmux new-window -t $session:$window -n '1class_1step_lr3'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_lr3_$method_$session $2 '20_clients_dirichlet_0.01' 3 1 $method $4 $5 $6" C-m

window=6
tmux new-window -t $session:$window -n '1class_1step_lr4'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_lr4_$method_$session $2 '20_clients_dirichlet_0.01' 4 1 $method $4 $5 $6" C-m

window=7
tmux new-window -t $session:$window -n '1class_1step_lr5'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_lr5_$method_$session $2 '20_clients_dirichlet_0.01' 5 1 $method $4 $5 $6" C-m



tmux attach-session -t $session