def scheduler(max_lr, min_lr, t, epoch, category='const'):
    '''decaying learning rate scheduler, max_lr: initial learning rate; min_lr: ending learning rate; t: epoch number;
    epoch: total number of epochs; category: const/linear/cosine/reciprocal'''
    if category == 'const':
        assert max_lr == min_lr
        return max_lr
    elif category == 'linear':    # linearly decay the learning rate
        return min_lr + (max_lr - min_lr) / epoch * (epoch - t)
    elif category == 'cosine':    # from SGDR: stochastic gradient descent with warm restarts (ICLR 2017)
        return min_lr + 0.5 * (max_lr - min_lr) * (1.0 + np.cos(np.pi * t / epoch))
    elif category == 'reciprocal':
        return max_lr / (1 + (max_lr - min_lr) * t / (epoch * min_lr))
    else:
        raise NotImplementedError
        return
