#!/bin/bash
session="$1"
device="$2"
method="$3"          #e.g. [c1,c1,c1,v]
step=$4
environment=${8:-"Mahdi"}

file="exp_configs/CIFAR10_CNN/algorithm/fedavg.sh"

tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window '1class_0.001'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file ${step}_fedavg_${method}_${session} $2 '1class_full' 0.001 $step $method $5 $6 $7" C-m

window=1
tmux new-window -t $session:$window -n '1class_0.005'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file ${step}_fedavg_${method}_${session} $2 '1class_full' 0.005 $step $method $5 $6 $7" C-m

window=2
tmux new-window -t $session:$window -n '1class_0.01'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file ${step}_fedavg_${method}_${session} $2 '1class_full' 0.01 $step $method $5 $6 $7" C-m

window=3
tmux new-window -t $session:$window -n '1class_0.05'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file ${step}_fedavg_${method}_${session} $2 '1class_full' 0.05 $step $method $5 $6 $7" C-m

window=4
tmux new-window -t $session:$window -n '1class_0.1'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file ${step}_fedavg_${method}_${session} $2 '1class_full' 0.1 $step $method $5 $6 $7" C-m

window=5
tmux new-window -t $session:$window -n '1class_0.5'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file ${step}_fedavg_${method}_${session} $2 '1class_full' 0.5 $step $method $5 $6 $7" C-m

window=6
tmux new-window -t $session:$window -n '1class_1'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file ${step}_fedavg_${method}_${session} $2 '1class_full' 1 $step $method $5 $6 $7" C-m


tmux attach-session -t $session