#!/bin/bash
session="$1"
device="$2"
method="$3"          #e.g. "[c1,c1,c1,v]"
environment=${7:-"Mahdi"}

file_path="exp_configs/PACS_ResNet/algorithm/fedavg.sh"


tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window 'no_norm_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$method_$session 0 'dirichlet_0.5_full' 0.001 1 no_norm $4 $5 $6" C-m

window=1
tmux new-window -t $session:$window -n 'no_norm_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$method_$session 1 'dirichlet_0.5_full' 0.001 10 no_norm $4 $5 $6" C-m

window=2
tmux new-window -t $session:$window -n 'ln_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$method_$session 2 'dirichlet_0.5_full' 0.001 1 group_norm_after --affine $5 $6" C-m

window=3
tmux new-window -t $session:$window -n 'ln_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$method_$session 3 'dirichlet_0.5_full' 0.001 10 group_norm_after --affine $5 $6" C-m

window=4
tmux new-window -t $session:$window -n 'fn_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$method_$session 3 'dirichlet_0.5_full' 0.001 1 N_prime $4 $5 $6" C-m

window=5
tmux new-window -t $session:$window -n 'fn_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$method_$session 2 'dirichlet_0.5_full' 0.001 10 N_prime $4 $5 $6" C-m


tmux attach-session -t $session