#!/bin/bash
session="$1"
device="$2"
method="$3"          #e.g. "[c1,c1,c1,v]"
lr_1step=$4
lr_10step=$5
lr_20step=$6
environment=${10:-"Mahdi"}

file_path="exp_configs/TinyImageNet_ResNet/algorithm/fedavg.sh"


tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window 'dir_0.01_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$method_$session $2 '20_clients_dirichlet_0.01' $lr_1step 1 $method $7 $8 $9" C-m

window=1
tmux new-window -t $session:$window -n 'dir_0.01_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$method_$session $2 '20_clients_dirichlet_0.01' $lr_10step 10 $method $7 $8 $9" C-m

window=2
tmux new-window -t $session:$window -n 'dir_0.01_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 20step_fedavg_$method_$session $2 '20_clients_dirichlet_0.01' $lr_20step 20 $method $7 $8 $9" C-m

window=3
tmux new-window -t $session:$window -n 'dir_0.02_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$method_$session $2 '20_clients_dirichlet_0.02' $lr_1step 1 $method $7 $8 $9" C-m

window=4
tmux new-window -t $session:$window -n 'dir_0.02_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$method_$session $2 '20_clients_dirichlet_0.02' $lr_10step 10 $method $7 $8 $9" C-m

window=5
tmux new-window -t $session:$window -n 'dir_0.02_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 20step_fedavg_$method_$session $2 '20_clients_dirichlet_0.02' $lr_20step 20 $method $7 $8 $9" C-m

window=6
tmux new-window -t $session:$window -n 'dir_0.05_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 1step_fedavg_$method_$session $2 '20_clients_dirichlet_0.05' $lr_1step 1 $method $7 $8 $9" C-m

window=7
tmux new-window -t $session:$window -n 'dir_0.05_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 10step_fedavg_$method_$session $2 '20_clients_dirichlet_0.05' $lr_10step 10 $method $7 $8 $9" C-m

window=8
tmux new-window -t $session:$window -n 'dir_0.05_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file_path 20step_fedavg_$method_$session $2 '20_clients_dirichlet_0.05' $lr_20step 20 $method $7 $8 $9" C-m


tmux attach-session -t $session