#!/bin/bash
session="$1"
device="$2"
environment=${7:-"Mahdi"}

file="exp_configs/TinyImageNet_ResNet/algorithm/scaffold.sh"
alg="scaffold"

norm_methods_per_layer=${3:-"no_norm"}

tmux new-session -d -s $session

window=0
tmux rename-window -t $session:$window 'dir_0.01_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 1step_$alg_$session $2 '20_clients_dirichlet_0.01' 0.01 1 $norm_methods_per_layer $4" C-m

window=1
tmux new-window -t $session:$window -n 'dir_0.01_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 10step_$alg_$session $2 '20_clients_dirichlet_0.01' 0.01 10 $norm_methods_per_layer $4" C-m

window=2
tmux new-window -t $session:$window -n 'dir_0.01_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 20step_$alg_$session $2 '20_clients_dirichlet_0.01' 0.01 20 $norm_methods_per_layer $4 " C-m

window=3
tmux new-window -t $session:$window -n 'dir_0.02_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 1step_$alg_$session $2 '20_clients_dirichlet_0.02' 0.01 1 $norm_methods_per_layer $4" C-m

window=4
tmux new-window -t $session:$window -n 'dir_0.02_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 10step_$alg_$session $2 '20_clients_dirichlet_0.02' 0.01 10 $norm_methods_per_layer $4"  C-m

window=5
tmux new-window -t $session:$window -n 'dir_0.02_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 20step_$alg_$session $2 '20_clients_dirichlet_0.02' 0.01 20 $norm_methods_per_layer $4" C-m

window=6
tmux new-window -t $session:$window -n 'dir_0.05_1step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 1step_$alg_$session $2 '20_clients_dirichlet_0.05' 0.01 1 $norm_methods_per_layer $4" C-m

window=7
tmux new-window -t $session:$window -n 'dir_0.05_10step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 10step_$alg_$session $2 '20_clients_dirichlet_0.05' 0.01 10 $norm_methods_per_layer $4" C-m
window=8
tmux new-window -t $session:$window -n 'dir_0.05_20step'
tmux send-keys -t $session:$window "source /opt/anaconda3/bin/activate $environment" C-m
tmux send-keys -t $session:$window ". $file 20step_$alg_$session $2 '20_clients_dirichlet_0.05' 0.01 20 $norm_methods_per_layer $4" C-m


tmux attach-session -t $session