# POT GPU

## Aim 

- This POT GPU folder is a small library that allows to compute the fused-gromov-wasserstein distance on GPU, which can significantly speed up the processing time for large document graphs. However due to the nature of the computations involved, it is not possible to parallelize an exact version of the Earth Mover's Distance (EMD) on GPU.
This is why we decided to implement a Sinkhorn approximation of the EMD, which is a common technique to approximate the EMD in a more efficient way. The fused-gromov-wasserstein distance is then computed using this Sinkhorn approximation.


- For accuracy purpose we implemented a polished version of the Sinkhorn approximation, which will go through the basic steps of the Sinkhorn algorithm and uses one call to the emd solver at the end to correct the results. It can be used to speed up the process while still aiming to obtain accurate results.

- This small library is then used in both `utils_fgw_torch.py` and `kg_fgw_torch.py` that aims to implement the Kurisu-G² algorithm with GPU acceleration.
