import os
from openai import OpenAI

def build_prompt_path(question, path, G):
    context = "\n".join([f"{nid}: {G.nodes[nid]['text']}" for nid in path])
    return f"""Voici les extraits traversés dans le graphe :

{context}

Question : {question}
Réponse :"""

def build_prompt(question, context):
    return f"""Voici des extraits de documents pertinents  :
{context}

Question : {question}
Réponse :"""

def ask_llm(prompt, client):
    response = client.chat.completions.create(
        model="llama3",
        messages=[{"role": "user", "content": prompt}],
        temperature=0.2,
    )
    return response.choices[0].message.content

# Matching exact de la réponse 

def build_EM_prompt(question, context):
    return f"""Here are the relevant excerpts from the documents:
{context}
Please answer the question by retrieving the exact answer from the provided context without sentence generation.
Question : {question}
Answer :"""


def build_EM_prompt_v2(question, context):
    return f"""You are an extraction model.

You will be given a question and a set of context excerpts. Your task is to extract a **short and exact answer span** that appears **verbatim** in the context.

- You can try to infer the answer from the context if it is not explicitly stated.
- Do not generate or rephrase the answer.
- Only return the answer span found **word for word** in the context.
- If the answer is a closed question (e.g., "yes" or "no"), answer with "yes" or "no".
- If the answer is an open question, provide the most relevant words that directly answer the question.
---

Context:
{context}

---

Question: {question}

Answer:"""


def ask_llm_strict(prompt, client):
    response = client.chat.completions.create(
        model="llama3",
        messages=[
    {"role": "system", "content": "You are a strict answer extractor. Only return the shortest possible answer span verbatim from the context."},
    {"role": "user", "content": prompt},
        ],
        temperature=0.2,
    )
    return response.choices[0].message.content



def build_EM_prompt_v3(question, context):
    return f"""You are an extraction model.

You will be given a question and a set of context excerpts. Your task is to extract a **short and exact answer span** that appears **verbatim** in the context.

Instructions:
- If the question is a **yes/no question**, answer with **"yes"** or **"no"** only.
- If the question is an **open-ended question**, return only the **fewest words** necessary to directly answer the question, exactly as they appear in the context.
- Do not rephrase, do not explain, do not add quotes or any extra formatting.
- Do not say "answer span", "verbatim", or anything else. Just return the answer.

---

Context:
{context}

---

Question: {question}

Answer:"""




# Fonction de résumé du contexte avec axe principaux. 

def resume_context(context,client):
    prompt= f""" Voici des concaténations de phrases extraites : 
{context}
Effectue un résumé de ces élements en extrayant les axes principaux et les idées clés.
Résumé :"""
    response = ask_llm(prompt, client)
    return response


def summurize_axe(context, client):
    prompt = f"""Voici des extraits de documents pertinents :
{context}
Fais une liste de tous les axes principaux qui sont explicitement mentionnés dans ces extraits.
Liste des axes principaux :"""
    response = ask_llm(prompt, client)
    return response


def generate_knowledge_card(context, question=None, client=None):
    """
    Génère une fiche de connaissance structurée et esthétique à partir d'éléments contextuels.
    
    Args:
        context: Le contenu textuel à transformer en fiche
        title: Titre optionnel pour la fiche
        client: Client LLM configuré
    
    Returns:
        Fiche de connaissance formatée
    """
    title_section = f"sur le thème de la question '{question}'" if question else ""

    prompt = f"""Tu es un expert en création de fiches de connaissance pédagogiques et esthétiques.

À partir des éléments contextuels fournis, crée une fiche de connaissance complète répondant à la problématique {title_section} en suivant cette structure précise :

## 📋 STRUCTURE REQUISE :

### 🎯 **TITRE PRINCIPAL**
[Un titre accrocheur et informatif]

### 📖 **RÉSUMÉ EXÉCUTIF**
[2-3 phrases qui résument l'essentiel]

### 🔑 **CONCEPTS CLÉS**
• **Concept 1** : Définition claire et concise
• **Concept 2** : Définition claire et concise
• **Concept 3** : Définition claire et concise

### 🧩 **POINTS ESSENTIELS**
1. **Point principal 1**
   - Détail important
   - Exemple ou précision

2. **Point principal 2**
   - Détail important
   - Exemple ou précision

3. **Point principal 3**
   - Détail important
   - Exemple ou précision

### 🔗 **RELATIONS ET LIENS**
- Connexion avec [concept/domaine]
- Impact sur [domaine/processus]
- Dépendance de [élément]

### ⚡ **À RETENIR**
> Citation ou point marquant à mémoriser

### 🎯 **APPLICATIONS PRATIQUES**
• Usage 1 : [contexte d'application]
• Usage 2 : [contexte d'application]
• Usage 3 : [contexte d'application]

### 📊 **MÉTRIQUES/CHIFFRES CLÉS** (si applicable)
• Donnée 1 : [valeur et signification]
• Donnée 2 : [valeur et signification]

---

## 📚 CONTENU À TRAITER :

{context}

---

## 🎨 INSTRUCTIONS DE STYLE :

- Utilise des **émojis** pour rendre la fiche visuellement attrayante
- **Hiérarchise** l'information du plus important au plus détaillé
- Utilise un **langage clair** et accessible
- Crée des **connections logiques** entre les concepts
- **Synthétise** sans perdre les informations cruciales
- **Formate** avec des listes, tableaux si nécessaire
- Ajoute des **exemples concrets** quand c'est pertinent

Génère maintenant une fiche de connaissance complète et professionnelle :"""

    if client:
        response = ask_llm(prompt, client)
        return response
    else:
        return prompt


def generate_visual_summary(context, format_type="mindmap", client=None):
    """
    Génère un résumé visuel structuré (mindmap, schéma, timeline, etc.).
    
    Args:
        context: Le contenu à visualiser
        format_type: Type de visualisation ("mindmap", "schema", "timeline", "process")
        client: Client LLM configuré
    
    Returns:
        Résumé visuel formaté
    """
    
    format_instructions = {
        "mindmap": """
🧠 **CARTE MENTALE**

```
                    [THÈME CENTRAL]
                          |
        ┌─────────────────┼─────────────────┐
        │                 │                 │
   [BRANCHE 1]        [BRANCHE 2]      [BRANCHE 3]
        │                 │                 │
    ├─ Sous-idée      ├─ Sous-idée      ├─ Sous-idée
    ├─ Sous-idée      ├─ Sous-idée      ├─ Sous-idée
    └─ Sous-idée      └─ Sous-idée      └─ Sous-idée
```""",
        
        "schema": """
📊 **SCHÉMA STRUCTUREL**

```
┌─────────────────────────────────────────────┐
│                 ÉLÉMENT 1                   │
│  ┌─────────────┐    ┌─────────────────────┐ │
│  │ Composant A │ ──→│    Composant B      │ │
│  └─────────────┘    └─────────────────────┘ │
└─────────────────────────────────────────────┘
                        │
                        ▼
┌─────────────────────────────────────────────┐
│                 ÉLÉMENT 2                   │
└─────────────────────────────────────────────┘
```""",
        
        "timeline": """
⏰ **CHRONOLOGIE**

```
📅 Phase 1  ──→  📅 Phase 2  ──→  📅 Phase 3
    │               │               │
    ▼               ▼               ▼
  Action          Action          Action
  Résultat        Résultat        Résultat
```""",
        
        "process": """
⚙️ **PROCESSUS**

```
[ENTRÉE] ──→ [ÉTAPE 1] ──→ [ÉTAPE 2] ──→ [ÉTAPE 3] ──→ [SORTIE]
                │             │             │
                ▼             ▼             ▼
           Validation    Traitement     Contrôle
```"""
    }
    
    format_instruction = format_instructions.get(format_type, format_instructions["mindmap"])
    
    prompt = f"""Tu es un expert en visualisation d'information et en design de contenu éducatif.

Crée un résumé visuel de type **{format_type.upper()}** à partir du contenu fourni.

{format_instruction}

## 🎯 OBJECTIFS :
- **Structurer** visuellement l'information
- **Hiérarchiser** les éléments par importance
- **Montrer** les relations et connexions
- Utiliser des **symboles ASCII** pour créer des diagrammes
- **Synthétiser** sans perdre l'essence

## 📚 CONTENU À VISUALISER :

{context}

---

## 🎨 INSTRUCTIONS :
- Utilise des **caractères ASCII** pour les diagrammes (─│┌┐└┘├┤┬┴┼)
- Ajoute des **émojis** pour identifier les catégories
- **Hiérarchise** avec des niveaux visuels clairs
- Crée des **connexions** logiques entre éléments
- **Étiquette** clairement chaque section

Génère maintenant le résumé visuel complet :"""

    if client:
        response = ask_llm(prompt, client)
        return response
    else:
        return prompt


def generate_comparative_analysis(context1, context2, title1="Élément A", title2="Élément B", client=None):
    """
    Génère une analyse comparative structurée entre deux éléments contextuels.
    
    Args:
        context1: Premier élément à comparer
        context2: Deuxième élément à comparer
        title1: Titre du premier élément
        title2: Titre du deuxième élément
        client: Client LLM configuré
    
    Returns:
        Analyse comparative formatée
    """
    
    prompt = f"""Tu es un expert en analyse comparative et en synthèse documentaire.

Crée une analyse comparative complète et structurée entre les deux éléments fournis.

## 📊 **ANALYSE COMPARATIVE : {title1} vs {title2}**

### 🎯 **RÉSUMÉ EXÉCUTIF**
[Synthèse des principales différences et similitudes]

### 📋 **TABLEAU COMPARATIF**

| Critère | {title1} | {title2} | Analyse |
|---------|----------|----------|---------|
| **Caractéristique 1** | [Description] | [Description] | [Différence/Similitude] |
| **Caractéristique 2** | [Description] | [Description] | [Différence/Similitude] |
| **Caractéristique 3** | [Description] | [Description] | [Différence/Similitude] |

### ✅ **SIMILITUDES**
• Point commun 1 : [explication]
• Point commun 2 : [explication]
• Point commun 3 : [explication]

### ⚖️ **DIFFÉRENCES CLÉS**
• **{title1}** : [spécificité unique]
• **{title2}** : [spécificité unique]

### 🔍 **ANALYSE DÉTAILLÉE**

#### 🏆 **Avantages de {title1}**
- Avantage 1 : [explication]
- Avantage 2 : [explication]

#### 🏆 **Avantages de {title2}**
- Avantage 1 : [explication]
- Avantage 2 : [explication]

#### ⚠️ **Limitations**
- **{title1}** : [limitation]
- **{title2}** : [limitation]

### 🎯 **RECOMMANDATIONS**
- **Quand choisir {title1}** : [contexte d'usage]
- **Quand choisir {title2}** : [contexte d'usage]

### 📈 **IMPACT ET IMPLICATIONS**
[Analyse des conséquences et implications pratiques]

---

## 📚 ÉLÉMENTS À COMPARER :

### 🔷 **{title1}** :
{context1}

### 🔶 **{title2}** :
{context2}

---

Génère maintenant l'analyse comparative complète et objective :"""

    if client:
        response = ask_llm(prompt, client)
        return response
    else:
        return prompt


