# Copyright 2024 The Flax Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Default Hyperparameter configuration."""

import ml_collections


def get_config():
  """Get the default hyperparameter configuration."""
  config = ml_collections.ConfigDict()
  config.dataset_name = 'mnist'#"cifar10"#
  config.model_name = "mnist"
  config.act_fn = "colu"
  config.variant = "soft"
  config.share_axis = True
  config.learning_rate = 1e-3
  config.latents = 500
  config.num_groups = 100
  config.batch_size = 128
  config.num_epochs = 100
  config.seed = 0
  return config
