from utils import chain_options
import click

modadd = chain_options(
    click.option("--dir"              , "dir"              , type=click.Path() , default="./"     , help="path in which to store the experiments"),
    click.option("--seed"             , "seed"             , type=int          , default=42       , help="seed of the experiment"                ),
    click.option("--epochs"           , "epochs"           , type=int          , default=100      , help="number of training epochs"             ),
    click.option("--data-device"      , "data_device"      , type=str          , default="cpu"    , help="device in which to store the data"     ),
    click.option("--etv"              , "etv"              , type=int          , default=10       , help="number of epoch before a validation"   ),
    click.option("--device"           , "device"           , type=str          , default="cuda:0" , help="device in which to run the training"   ),
    click.option("--train-batch-size" , "train_batch_size" , type=int          , default=32       , help="train batch size"                      ),
    click.option("--eval-batch-size"  , "eval_batch_size"  , type=int          , default=512      , help="eval batch size"                       ),
    click.option("--src-symbols"      , "src_symbols"      , type=int          , default=16       , help="number of addend symbols"              ),
    click.option("--tgt-symbols"      , "tgt_symbols"      , type=int          , default=8        , help="number of target symbols"              ),
    click.option("--compile"          , "compile"          , type=bool         , default=False    , help="compile the model before training"     ),
    click.option("--learning-rate"    , "learning_rate"    , type=float        , default=0.0001   , help="learning rate"                         ),
    click.option("--weight-decay"     , "weight_decay"     , type=float        , default=0.01     , help="weight deacy"                          )
)
