#pragma once
#include "bn.h"

#define PUT(x) std::cout << #x << "\t=" << (x) << std::endl;

const struct Point {
	struct G2 {
		const char *aa;
		const char *ab;
		const char *ba;
		const char *bb;
	} g2;
	struct G1 {
		int a;
		int b;
	} g1;
} g_pointTbl[] = {
#ifdef BN_SUPPORT_SNARK
	// SNARK1(b = 3)
	{
		{
			"15267802884793550383558706039165621050290089775961208824303765753922461897946",
			"9034493566019742339402378670461897774509967669562610788113215988055021632533",
			"644888581738283025171396578091639672120333224302184904896215738366765861164",
			"20532875081203448695448744255224543661959516361327385779878476709582931298750",
		},
		{
			1, 2
		},
	},
	// SNARK2(b = 82)
	{
		{
			"7281644703356799059368313064438243279269372005747477888712173236228325795991",
			"15160700668152503952980485502602536850541312794041965342451842375663084147486",
			"13523979532236795535820810482891703536907572704519492618036353386190612673074",
			"15929067770616689398844794432758732907995965312283969374632681891490787470887",
		},
		{
			-1, 9
		},
	},
#else
	// Aranha
	{
		{
			"12723517038133731887338407189719511622662176727675373276651903807414909099441",
			"4168783608814932154536427934509895782246573715297911553964171371032945126671",
			"13891744915211034074451795021214165905772212241412891944830863846330766296736",
			"7937318970632701341203597196594272556916396164729705624521405069090520231616",
		},
		{
			-1, 1
		},
	},
#endif
};

inline const Point& selectPoint(const bn::CurveParam& cp)
{
#ifdef BN_SUPPORT_SNARK
	if (cp.b != 3 && cp.b != 82) {
		printf("not support point for b=%d\n", cp.b);
		exit(1);
	}
	return g_pointTbl[cp.b == 3 ? 0 : 1];
#else
	if (cp != bn::CurveFp254BNb) {
		printf("not support except for CurveFp254BNb");
		exit(1);
	}
	return g_pointTbl[0];
#endif
}
