#include "bn.h"
#include "test_point.hpp"

static int errNum = 0;
const char *expect = "[[[8118772341496577043438385328606447626730215814727396173233264007541007797690,6742571767760762192519140673058087976840103832045324348366170860928670686713],"
" [9727912590495366720378364920530546614235713408261568635512172059018197267630,10180700148605185348549931182990442059136187839792856455707820203302941578832],"
" [5054507763444412917986776641611331046146804026682679569910978464879371792565,6917005519826733659554708445125877487590687705432214234949972860245110398023]],"
" [[10448556317747236258066222816126375978842661908560317699736569642190930635294,1516980358051268127904344653343215863076753141133525905743113718749531324025],"
" [9794836735385959178744195210089532061310424844916928682580569566332541022353,9375574834170998962484906689780052970915033987453510324648351251071086068423],"
" [710778048594563655498360873129325895716179849942646859397874562033386335205,10688745994254573144943003027511098295097561129365638275727908595677791826005]]]";

template<class T, class S>
void verify(const char *msg, const T& a, const S& b)
{
	if (a == b) {
		printf("%s : ok\n", msg);
	} else {
		printf("%s : ng\n", msg);
		PUT(a);
		PUT(b);
		errNum++;
	}
}

int main()
	try
{
//	bn::CurveParam cp = bn::CurveSNARK1;
	bn::CurveParam cp = bn::CurveFp254BNb;
	using namespace bn;
	// init my library
	Param::init(cp);
	const Point& pt = selectPoint(cp);
	const Ec2 g2(
		Fp2(Fp(pt.g2.aa), Fp(pt.g2.ab)),
		Fp2(Fp(pt.g2.ba), Fp(pt.g2.bb))
	);
	const Ec1 g1(pt.g1.a, pt.g1.b);

	PUT(g1);
	PUT(g2);
	Fp12 e1, e2;
	opt_atePairing(e1, g2, g1);
	PUT(e1);
	{
		std::stringstream ss(expect);
		ss >> e2;
	}
	printf("%s\n", e1 == e2 ? "OK" : "NG");
} catch (std::exception& e) {
	printf("ERR %s\n", e.what());
}


