# AudiFair

This repository provides an implementation of AudiFair. The zero-knowledge proof and commitment code are located in `AudiFair/src`.  
The decision tree prediction ZKP implementation is forked from [zkDTA](https://github.com/TAMUCrypto/ZKDT_release) provided by CCS'20 Zhang et al.

Code for proving and verifying the fairness of a decision tree is in `AudiFair/src/dt_batch.cpp` and `AudiFair/include/gadgets/dt_batch_gadget.h`.

The hash-based secure coin tossing protocol and synthetic data generation are implemented in `synth_gen.py`.  
Fairness score calculations are performed in `test_pub.py`.

Dependencies are listed in `environment.yml`.  
To set up the virtual environment with conda, run:

```
mamba create -n fairaud python=3.12
```

## Datasets

The Adult and Default Credit datasets are available in `AudiFair/datasets`. The ACSIncome dataset is automatically retrieved by the `synth_gen.py` and `test_pub.py` scripts below. 

## Coin Tossing and Data Generation

To perform coin tossing and generate synthetic data, run:
```
python synth_gen.py --data <credit|acs|adult> --model <CTGAN|TVAE> --trainsize <num_train_samples> --samplesize <num_synthetic_samples> --epc <epoch>
```
This command saves a CSV file in `AudiFair/datasets`.

## Test Fairness Scores

Train decision trees on a reference dataset, calculate fairness scores using a test dataset, and save the trained tree in `AudiFair/Model` as a `.txt` file:

```
python test_pub.py --data <credit|acs|adult> --testdata datasets/file_name.csv --trainsize <num_samples_to_train_tree> --samplesize <num_synthetic_samples_to_calculate_fairness> --tree_depth 10
```

## Compile ZKP

In the `AudiFair` folder, compile the code by running:
```
./run_build
```

## Commit Tree and ZKP for Fairness

To run ZKP setup, commit, prove, and verify using tree data from `AudiFair/Model` and test data from `AudiFair/datasets`, execute:

```
./run_batch.sh --testsize <num_test_samples> --data <test|credit|acs|adult> --metric <dp|eqod|mrd>
```

Currently, file names are hardcoded in `AudiFair/src/dt_batch.cpp` and can be changed manually.
To check circuit constraints without generating a proof, use the `--dry` option.
