import os
from random import randint
import uuid
import numpy as np
from tqdm import tqdm
import torch
import pdb



def validate_clf(model, task, args, val_examples=500):
	device = model.device
	task_metric = task.get_metric()

	batch_size = args.batch_size

	accs = []
	for _ in range(val_examples // batch_size):
		xs, ys = task.sample_data()
		output = model(xs.to(device))
		acc = task_metric(output, ys.to(device)).mean().item()
		accs.append(acc)
	
	return np.mean(accs)
