#!/bin/bash

generator_id=mistral7b-ep2
verifier_id=n100-scahead-mse-lm-token-TVM

n_beam=10
n_sampling_steps=40


model_name_or_path=~/models/gsm8k/generators/${generator_id}
verifier_model_name_or_path=~/models/gsm8k/verifiers/${generator_id}-${verifier_id}


accelerate launch \
  --main_process_port=20659 \
  eval_generator_by_step.py \
  --model_name_or_path ${model_name_or_path} \
  --verifier_model_name_or_path ${verifier_model_name_or_path} \
  --dataset gsm8k \
  --data_dir data/gsm8k \
  --output_dir eval_results/gsm8k/generator_with_verifier \
  --target_set test \
  --inference_mode beam \
  --batch_size 26 \
  --vs_batch_size 64 \
  --n_beam ${n_beam} \
  --n_sampling_steps ${n_sampling_steps} \
  --max_n_step 10 \
  --max_step_length 100 \
  --dedup_mode 0 \
  --do_sample True \
  --temperature 0.7 \
  --top_k 50 \
  --top_p 1.0 \
  --max_new_tokens 400 \
  --seed 42
