# Code for Small Noise Defense

Code for Small Noise Defense ("Small Input Noise is Enough to Defend Against Query-based Black-box Attacks" in submission to ICLR 2021)

## Experiment with the ImageNet dataset

### Attack experiment

* Example command

> python run_attack_imagenet.py --data_root /Path to ImageNet/ --attack=SO --defense=gaussian --sigma=0.01

* supported attacks: 'SO', 'HSJA', 'GD', 'SB', 'SBD', 'BD', 'SSA'

(Sign-OPT, HSJA, GeoDA, SimBA, SimBA-DCT, Bandit-TD, Subspace Attack)

* supported defenses: 'gaussian', 'rnp', 'AT'

---

* Note: for SB attack

> python run_attack_imagenet.py --attack=SB --data_root /Path to ImageNet/ --sigma=0.01 --alpha=0 --beta=0 --defense=gaussian --pixel_attack --freq_dims=224 --order=rand

* Note: for SBD attack

> python run_attack_imagenet.py --attack=SBD --data_root /Path to ImageNet/ --sigma=0.01 --alpha=0 --beta=0 --defense=gaussian

### Evaluation of clean accuracy
* Example command
> python run_baseline_imagenet.py --data_root /Path to ImageNet/ --defense=gaussian --sigma=0.01 --alpha=0 --beta=0
* Defenses supported: 'gaussian', 'rnp', 'AT'

## Experiment with the CIFAR-10 dataset

### Attack experiment

* Example command

> python run_attack_cifar.py --attack=SO --defense=gaussian --sigma=0.01 --avg_iter=1

* supported attacks: 'BA', 'SO', 'HSJA', 'GD'

(Boundary Attack, Sign-OPT, HSJA, GeoDA)

* supported defenses: 'gaussian', 'rnp', 'AT'

* for an adaptive attack with EOT against SND, increase avg_iter
---
### Evaluation of clean accuracy

* Example command
> python run_baseline_cifar.py --defense=gaussian --sigma=0.01 --alpha=0 --beta=0
* Defenses supported: 'gaussian', 'PNI', 'RSE'


## Code Reference

### HSJA and BA
We borrowed and modified the codes from ART library (https://github.com/Trusted-AI/adversarial-robustness-toolbox)

### Sign-OPT
We borrowed and modified the codes from the official code (https://github.com/cmhcbb/attackbox)

### SimBA
We borrowed and modified the codes from the official code (https://github.com/cg563/simple-blackbox-attack)
* Our main framework is initially based on SimBA's code.

### GeoDA
We borrowed and modified the codes from the official code (https://github.com/thisisalirah/GeoDA)

### Bandit-TD
We borrowed and modified the codes from the official code (https://github.com/MadryLab/blackbox-bandits)

### Subspace Attack
We borrowed and modified the codes from the official code (https://github.com/ZiangYan/subspace-attack.pytorch)

### PNI
We borrowed and modified the codes and pretrained model from the official github (https://github.com/elliothe/CVPR_2019_PNI)