# MISO-VFI: A Multi-In-Single-Out Network for Video Frame Interpolation without optical flow

## How to use?
### Requirements
- pytorch == 1.10.0
- torchvision
- timm
- imageio-ffmpeg
- numpy

### Datasets
**Vimeo90K datasets**
We used [Xue, Tianfan, et al.](http://toflow.csail.mit.edu/index.html)'s Dataset for the vimeo experiment.
```bash
$ mkdir /data
$ cd /data
$ wget http://data.csail.mit.edu/tofu/dataset/vimeo_septuplet.zip # (82G)
$ unzip vimeo_septuplet.zip
```
### Training & Evaluation

**train**
```bash
$ python main.py --dataname vimeo --epochs 100 --batch_size 8 --test_batch_size 8 --vgg_loss True --perceptual True --mars_weight ./weights/kinetics-pretrained.pth --num_workers 16 --ex_name vimeo_exp --lr 0.001 --gpu 0,1,2,3 --data_root /data/vimeo_septuplet
```

`MARS Kinetics pre-trained weight` can get from [Google Drive(anonymous account)](https://drive.google.com/file/d/1WKT3pQtCbXcJn_8gG9GRdSKrBWfBs2LW/view?usp=share_link) (we referred to the model of [MARS](https://github.com/craston/MARS).)

**evaluation**
```bash
$ python test.py --dataname vimeo --test_batch_size 4 --num_workers 16 --weight ./weights/vimeo-pretrained.pth --gpu 0,1,2,3 --data_root /data/vimeo_septuplet

# ---
# Results
# test mse:416.0105, mae:4615.9648, ssim:0.9552, psnr:37.19
```
If you want to get the vimeo90K pre-trained weight, Access this [Google Drive(anonymous account)](https://drive.google.com/file/d/1wmx82tU_oT5HbYmdceyM5Lkqm7IhB5Ye/view?usp=share_link).

## Thanks to
- This code is heavily borrowed from [SimVP](https://github.com/gaozhangyang/SimVP-Simpler-yet-Better-Video-Prediction).
- We cite [MARS](https://github.com/craston/MARS)'s ResNeXt model.
- We cite metrics for SSIM and PSNR on [E3D-LSTM](https://github.com/google/e3d_lstm/blob/master/src/trainer.py).
- We use LKA-module of [Visual-Attention-Network](https://github.com/Visual-Attention-Network).
- We refinement learnable filter module of [MagNet](https://github.com/VinAIResearch/MagNet).
- We use ConvNeXt and LayerNorm of [ConvNeXt](https://github.com/facebookresearch/ConvNeXt).
