# Supplementary material for *CADDA: Class-wise Automatic Differentiable Data Augmentation for EEG Signals*

The figures requires a long and complex setup to be run in a reasonable time.
This repo provides the code as is with:

- A specific branch for the [`braindecode`](https://github.com/braindecode/braindecode) package which is used in our experiments.
- A repo for automatic data augmentation with EEG.

We plan to integrate our changes to `braindecode` with their new data augmentation API and create package for automatic data-augmentation
where we will expose a proper API compatible with braindecode to all our implementation of the different automatic augmentation methods.


### Install instruction

To test the code, we recommend to install `braindecode-wip` and then `eeg-augment` in a conda env:

```bash
conda create -n test_cadda python=3.8
conda activate test_cadda
# remove cpuonly if you have access to a GPU
conda install -c pytorch pytorch cpuonly  

pip install ./braindecode-wip
pip install ./eeg-augmenti[test]
```
One can run the unit test in approximately 18 minutes on cpu only with:
```bash
cd ./eeg-augment
pytest -v
```

### Running Automatic differentiation experiments

```bash
mkdir outputs
cd eeg-augment
python diff_aug/diff_auto_augmentation.py ../outputs --config configs/search_config_6nights.yml --num_workers 2 -d cpu --n_jobs 2 --preload -s darts --grad_est relax
```
### Running other experiments

Refer to the README.md in mnist and cw-sleep-experiment folders. 