# Classwise augment for MNIST

Repository for tring out classwise augmentation search on MNIST


### Install

this repo can be installed using

```bash
pip install -e .
```

### Usage

The main script to reproduce a sketch of Figure.2 can be launched
with the following commands:

```bash
python main.py --n_trials 5 results  # ~6min
python main.py --no-classwise --n_trials 5 results  # ~6min
python main.py --baseline --n_trials 1 results  # ~6min
python plot.py results
```

The computations will tak approximately 15min
Note that to fully reproduce figure 2, one would need to run
many more trials. This is possible by increasing the `--n_trials`
value. To make the computation faster, one can launch multiple
script at once using different `--idx` to avoid duplicate
computations:


```bash
mkdir mnist_logs
for i in {1..10}
do
    CUDA_VISIBLE_DEVICES=0 python main.py \
        --n_trials 100 results --idx $i \
        > mnist_logs/cw_$i.log 2>&1 &  # 2h
    CUDA_VISIBLE_DEVICES=1 python main.py --no-classwise \
        --n_trials 100 results --idx $i \
        > mnist_logs/nocw_$i.log 2>&1 &  # 2h
done
tail -f mnist_logs/cw_1.log
```

This full script runs in approximately 2h on a Nvidia Tesla V100-DGXS-32GB .
    


